/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature.tree;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.util.block.IBlockPosQuery;
import biomesoplenty.common.world.gen.feature.tree.TreeFeatureBase;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraftforge.common.IPlantable;

public class CypressTreeFeature
extends TreeFeatureBase {
    private int trunkWidth = 1;

    protected CypressTreeFeature(IBlockPosQuery placeOn, IBlockPosQuery replace, BlockState log, BlockState leaves, BlockState altLeaves, BlockState vine, BlockState hanging, BlockState trunkFruit, int minHeight, int maxHeight, int trunkWidth) {
        super(placeOn, replace, log, leaves, altLeaves, vine, hanging, trunkFruit, minHeight, maxHeight);
        this.trunkWidth = trunkWidth;
    }

    public boolean checkSpace(IWorld world, BlockPos pos, int baseHeight, int height) {
        for (int y = 0; y <= height; ++y) {
            int trunkWidth = this.trunkWidth * (height - y) / height + 1;
            int trunkStart = MathHelper.func_76143_f((double)(0.25 - (double)trunkWidth / 2.0));
            int trunkEnd = MathHelper.func_76128_c((double)(0.25 + (double)trunkWidth / 2.0));
            int start = y <= baseHeight ? trunkStart : trunkStart - 1;
            int end = y <= baseHeight ? trunkEnd : trunkEnd + 1;
            for (int x = start; x <= end; ++x) {
                for (int z = start; z <= end; ++z) {
                    BlockPos pos1 = pos.func_177982_a(x, y, z);
                    if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        BlockPos pos2 = pos.func_177982_a(0, height - 2, 0);
        return world.func_180495_p(pos2).canBeReplacedByLeaves((IWorldReader)world, pos2);
    }

    public void generateLeafLayer(IWorld world, Random rand, BlockPos pos, int leavesRadius, int trunkStart, int trunkEnd, Set<BlockPos> changedLeaves, MutableBoundingBox boundingBox) {
        int start = trunkStart - leavesRadius;
        int end = trunkEnd + leavesRadius;
        for (int x = start; x <= end; ++x) {
            for (int z = start; z <= end; ++z) {
                int distFromTrunk;
                if (leavesRadius > 0 && (x == start || x == end) && (z == start || z == end) || (distFromTrunk = (x < 0 ? trunkStart - x : x - trunkEnd) + (z < 0 ? trunkStart - z : z - trunkEnd)) > 2) continue;
                this.placeLeaves(world, pos.func_177982_a(x, 0, z), changedLeaves, boundingBox);
            }
        }
    }

    public void generateBranch(IWorld world, Random rand, BlockPos pos, Direction direction, int length, Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, MutableBoundingBox boundingBox) {
        Direction.Axis axis = direction.func_176740_k();
        Direction sideways = direction.func_176746_e();
        for (int i = 1; i <= length; ++i) {
            BlockPos pos1 = pos.func_177967_a(direction, i);
            int r = i == 1 || i == length ? 1 : 2;
            for (int j = -r; j <= r; ++j) {
                if (i >= length && rand.nextInt(2) != 0) continue;
                this.placeLeaves(world, pos1.func_177967_a(sideways, j), changedLeaves, boundingBox);
            }
            if (length - i <= 2) continue;
            this.placeLeaves(world, pos1.func_177984_a(), changedLeaves, boundingBox);
            this.placeLeaves(world, pos1.func_177984_a().func_177967_a(sideways, -1), changedLeaves, boundingBox);
            this.placeLeaves(world, pos1.func_177984_a().func_177967_a(sideways, 1), changedLeaves, boundingBox);
            this.placeLog(world, pos1, axis, changedLogs, boundingBox);
        }
    }

    @Override
    protected boolean place(Set<BlockPos> changedLogs, Set<BlockPos> changedLeaves, IWorld world, Random random, BlockPos startPos, MutableBoundingBox boundingBox) {
        int trunkEnd;
        int trunkStart;
        int trunkWidth;
        int baseHeight;
        while (startPos.func_177956_o() > 1 && this.replace.matches(world, startPos) || world.func_180495_p(startPos).func_185904_a() == Material.field_151584_j) {
            startPos = startPos.func_177977_b();
        }
        for (int x = 0; x <= this.trunkWidth - 1; ++x) {
            for (int z = 0; z <= this.trunkWidth - 1; ++z) {
                if (this.placeOn.matches(world, startPos.func_177982_a(x, 0, z))) continue;
                return false;
            }
        }
        int height = GeneratorUtil.nextIntBetween(random, this.minHeight, this.maxHeight);
        int leavesHeight = height - (baseHeight = GeneratorUtil.nextIntBetween(random, (int)((float)height * 0.6f), (int)((float)height * 0.4f)));
        if (leavesHeight < 3) {
            return false;
        }
        if (!this.checkSpace(world, startPos.func_177984_a(), baseHeight, height)) {
            return false;
        }
        BlockPos pos = startPos.func_177981_b(height);
        this.placeLeaves(world, pos, changedLeaves, boundingBox);
        pos.func_177977_b();
        for (int i = 0; i < leavesHeight; ++i) {
            trunkWidth = this.trunkWidth * i / height + 1;
            trunkStart = MathHelper.func_76143_f((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = MathHelper.func_76128_c((double)(0.25 + (double)trunkWidth / 2.0));
            int radius = MathHelper.func_76125_a((int)i, (int)0, (int)2);
            if (i == leavesHeight - 1) {
                radius = 1;
            }
            if (radius == 0) {
                this.placeLeaves(world, pos, changedLeaves, boundingBox);
            } else if (radius < 2) {
                this.generateLeafLayer(world, random, pos, radius, trunkStart, trunkEnd, changedLeaves, boundingBox);
            } else {
                this.generateBranch(world, random, pos.func_177982_a(trunkStart, 0, trunkStart), Direction.NORTH, radius, changedLogs, changedLeaves, boundingBox);
                this.generateBranch(world, random, pos.func_177982_a(trunkEnd, 0, trunkStart), Direction.EAST, radius, changedLogs, changedLeaves, boundingBox);
                this.generateBranch(world, random, pos.func_177982_a(trunkEnd, 0, trunkEnd), Direction.SOUTH, radius, changedLogs, changedLeaves, boundingBox);
                this.generateBranch(world, random, pos.func_177982_a(trunkStart, 0, trunkEnd), Direction.WEST, radius, changedLogs, changedLeaves, boundingBox);
            }
            pos = pos.func_177977_b();
        }
        for (int y = 0; y < height - 1; ++y) {
            trunkWidth = this.trunkWidth * (baseHeight + 5 - y) / (baseHeight + 5) + 1;
            trunkStart = MathHelper.func_76143_f((double)(0.25 - (double)trunkWidth / 2.0));
            trunkEnd = MathHelper.func_76128_c((double)(0.25 + (double)trunkWidth / 2.0));
            if (trunkWidth < 1) {
                trunkStart = 0;
                trunkEnd = 0;
            }
            for (int x = trunkStart; x <= trunkEnd; ++x) {
                for (int z = trunkStart; z <= trunkEnd; ++z) {
                    this.placeLog(world, startPos.func_177982_a(x, y, z), changedLogs, boundingBox);
                }
            }
        }
        return true;
    }

    @Override
    public boolean placeLeaves(IWorld world, BlockPos pos, Set<BlockPos> changedBlocks, MutableBoundingBox boundingBox) {
        if (world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReader)world, pos)) {
            this.func_230367_a_((IWorldWriter)world, pos, this.leaves);
            this.placeBlock(world, pos, this.leaves, changedBlocks, boundingBox);
            return true;
        }
        return false;
    }

    public static class Builder
    extends TreeFeatureBase.BuilderBase<Builder, CypressTreeFeature> {
        protected int trunkWidth;

        public Builder trunkWidth(int a) {
            this.trunkWidth = a;
            return this;
        }

        public Builder() {
            this.minHeight = 6;
            this.maxHeight = 15;
            this.placeOn = (world, pos) -> world.func_180495_p(pos).canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)((SaplingBlock)Blocks.field_196674_t));
            this.replace = (world, pos) -> world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReader)world, pos) || world.func_180495_p(pos).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos).func_177230_c().func_203417_a((ITag)BlockTags.field_200030_g) || world.func_180495_p(pos).func_177230_c() == Blocks.field_150395_bd || world.func_180495_p(pos).func_177230_c() == BOPBlocks.willow_vine || world.func_180495_p(pos).func_177230_c() instanceof BushBlock;
            this.log = BOPBlocks.willow_log.func_176223_P();
            this.leaves = BOPBlocks.willow_leaves.func_176223_P();
            this.vine = BOPBlocks.willow_vine.func_176223_P();
            this.trunkWidth = 1;
        }

        @Override
        public CypressTreeFeature create() {
            return new CypressTreeFeature(this.placeOn, this.replace, this.log, this.leaves, this.altLeaves, this.vine, this.hanging, this.trunkFruit, this.minHeight, this.maxHeight, this.trunkWidth);
        }
    }
}

