/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.server.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.fml.ModList;

public class GenDataCommand {
    public static void dataGenCommand(CommandDispatcher<CommandSource> dispatcher) {
        String commandString = "gendata";
        ArrayList modIdList = new ArrayList();
        ModList.get().getMods().forEach(modContainer -> {
            String modId = modContainer.getModId();
            if (!modId.contains("forge")) {
                modIdList.add(modId);
            }
        });
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)commandString).then(Commands.func_197056_a((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> ISuggestionProvider.func_197013_a(modIdList.stream(), (SuggestionsBuilder)sb)).executes(cs -> {
            GenDataCommand.createBiomeDatapack((String)cs.getArgument("modid", String.class), (CommandContext<CommandSource>)cs);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)commandString).redirect((CommandNode)source));
    }

    public static void createBiomeDatapack(String modId, CommandContext<CommandSource> commandSource) {
        ArrayList<Biome> biomeList = new ArrayList<Biome>();
        boolean stopSpamFlag = false;
        Path dataPackPath = GenDataCommand.dataPackPath(((CommandSource)commandSource.getSource()).func_197023_e().func_73046_m().func_240776_a_(FolderName.field_237251_g_), modId);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        DynamicRegistries manager = ((CommandSource)commandSource.getSource()).func_197028_i().func_244267_aX();
        Registry biomeRegistry = WorldGenRegistries.field_243657_i;
        Registry featuresRegistry = WorldGenRegistries.field_243653_e;
        Registry structuresRegistry = WorldGenRegistries.field_243654_f;
        Registry carverRegistry = WorldGenRegistries.field_243652_d;
        Registry surfaceBuilderRegistry = WorldGenRegistries.field_243651_c;
        Registry structureProcessorRegistry = WorldGenRegistries.field_243655_g;
        GenDataCommand.createConfiguredSurfaceBuilderJson(modId, dataPackPath, gson, surfaceBuilderRegistry);
        GenDataCommand.createConfiguredFeatureJson(modId, dataPackPath, gson, featuresRegistry);
        GenDataCommand.createConfiguredCarverJson(modId, dataPackPath, gson, carverRegistry);
        GenDataCommand.createConfiguredStructureJson(modId, dataPackPath, gson, structuresRegistry);
        GenDataCommand.createProcessorListJson(modId, dataPackPath, gson, (Registry<StructureProcessorList>)structureProcessorRegistry);
        GenDataCommand.createBiomeJsonAndPackMcMeta(modId, commandSource, biomeList, stopSpamFlag, dataPackPath, gson, (Registry<Biome>)biomeRegistry, featuresRegistry, structuresRegistry, carverRegistry, surfaceBuilderRegistry);
    }

    private static void createWorldImportJson(String modId, Path dataPackPath, Gson gson, Registry<ConfiguredSurfaceBuilder<?>> surfaceBuildersRegistry) {
        for (Map.Entry surfaceBuilder : surfaceBuildersRegistry.func_239659_c_()) {
            Optional optional;
            Function surfaceBuilderCodec = JsonOps.INSTANCE.withEncoder((Encoder)ConfiguredSurfaceBuilder.field_244393_b_);
            ConfiguredSurfaceBuilder configuredSurfaceBuilder = (ConfiguredSurfaceBuilder)surfaceBuilder.getValue();
            if (!((RegistryKey)surfaceBuilder.getKey()).func_240901_a_().toString().contains(modId) || configuredSurfaceBuilder == null || !Objects.requireNonNull(surfaceBuildersRegistry.func_177774_c((Object)configuredSurfaceBuilder)).toString().contains(modId) || !(optional = ((DataResult)surfaceBuilderCodec.apply(() -> configuredSurfaceBuilder)).result()).isPresent()) continue;
            try {
                Path sbPath = GenDataCommand.configuredSurfaceBuilderJsonPath(dataPackPath, Objects.requireNonNull(surfaceBuildersRegistry.func_177774_c((Object)configuredSurfaceBuilder)), modId);
                Files.createDirectories(sbPath.getParent(), new FileAttribute[0]);
                Files.write(sbPath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static void createBiomeJsonAndPackMcMeta(String modId, CommandContext<CommandSource> commandSource, List<Biome> biomeList, boolean stopSpamFlag, Path dataPackPath, Gson gson, Registry<Biome> biomeRegistry, Registry<ConfiguredFeature<?, ?>> featuresRegistry, Registry<StructureFeature<?, ?>> structuresRegistry, Registry<ConfiguredCarver<?>> carverRegistry, Registry<ConfiguredSurfaceBuilder<?>> surfaceBuilderRegistry) {
        for (Map.Entry entry : biomeRegistry.func_239659_c_()) {
            String biomeKey = ((RegistryKey)Objects.requireNonNull(biomeRegistry.func_230519_c_(entry.getValue())).get()).func_240901_a_().toString();
            if (!biomeKey.contains(modId)) continue;
            biomeList.add((Biome)entry.getValue());
        }
        if (biomeList.size() > 0) {
            for (Biome biome : biomeList) {
                ResourceLocation key = biomeRegistry.func_177774_c((Object)biome);
                if (key == null) continue;
                Path biomeJsonPath = GenDataCommand.biomeJsonPath(dataPackPath, key, modId);
                Function biomeCodec = JsonOps.INSTANCE.withEncoder((Encoder)Biome.field_235051_b_);
                try {
                    Files.createDirectories(biomeJsonPath.getParent(), new FileAttribute[0]);
                    Optional optional = ((DataResult)biomeCodec.apply(() -> biome)).result();
                    if (!optional.isPresent()) continue;
                    JsonElement root = (JsonElement)optional.get();
                    JsonArray features = new JsonArray();
                    for (List list : biome.func_242440_e().func_242498_c()) {
                        GenerationStage.Carving[] stage = new JsonArray();
                        for (Supplier feature : list) {
                            featuresRegistry.func_230519_c_(feature.get()).ifPresent(arg_0 -> GenDataCommand.lambda$createBiomeJsonAndPackMcMeta$5((JsonArray)stage, arg_0));
                        }
                        features.add((JsonElement)stage);
                    }
                    root.getAsJsonObject().add("features", (JsonElement)features);
                    String surfaceBuilder = ((RegistryKey)surfaceBuilderRegistry.func_230519_c_(biome.func_242440_e().func_242500_d().get()).get()).func_240901_a_().toString();
                    root.getAsJsonObject().addProperty("surface_builder", surfaceBuilder);
                    JsonObject carvers = new JsonObject();
                    for (GenerationStage.Carving step : GenerationStage.Carving.values()) {
                        JsonArray stage = new JsonArray();
                        for (Supplier carver : biome.func_242440_e().func_242489_a(step)) {
                            carverRegistry.func_230519_c_(carver.get()).ifPresent(carverKey -> stage.add(carverKey.func_240901_a_().toString()));
                        }
                        if (stage.size() <= 0) continue;
                        carvers.add(step.func_222671_a(), (JsonElement)stage);
                    }
                    root.getAsJsonObject().add("carvers", (JsonElement)carvers);
                    JsonArray starts = new JsonArray();
                    for (Supplier start : biome.func_242440_e().func_242487_a()) {
                        structuresRegistry.func_230519_c_(start.get()).ifPresent(structureKey -> starts.add(structureKey.func_240901_a_().toString()));
                    }
                    root.getAsJsonObject().add("starts", (JsonElement)starts);
                    Files.write(biomeJsonPath, gson.toJson(root).getBytes(), new OpenOption[0]);
                }
                catch (IOException e) {
                    if (stopSpamFlag) continue;
                    ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.gendata.failed", new Object[]{modId}).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))), false);
                    stopSpamFlag = true;
                }
            }
            try {
                GenDataCommand.createPackMCMeta(dataPackPath, modId);
            }
            catch (IOException e) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.gendata.mcmeta.failed", new Object[]{modId}).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))), false);
            }
            IFormattableTextComponent filePathText = new StringTextComponent(dataPackPath.toString()).func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN)).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, dataPackPath.toString())).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("commands.gendata.hovertext"))));
            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.gendata.success", new Object[]{commandSource.getArgument("modid", String.class), filePathText}), false);
        } else {
            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.gendata.listisempty", new Object[]{modId}).func_240700_a_(text -> text.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED))), false);
        }
    }

    private static void createConfiguredFeatureJson(String modId, Path dataPackPath, Gson gson, Registry<ConfiguredFeature<?, ?>> featuresRegistry) {
        for (Map.Entry feature : featuresRegistry.func_239659_c_()) {
            Optional optional;
            Function featureCodec = JsonOps.INSTANCE.withEncoder((Encoder)ConfiguredFeature.field_236264_b_);
            ConfiguredFeature configuredFeature = (ConfiguredFeature)feature.getValue();
            if (!((RegistryKey)feature.getKey()).func_240901_a_().toString().contains(modId) || configuredFeature == null || !Objects.requireNonNull(featuresRegistry.func_177774_c((Object)configuredFeature)).toString().contains(modId) || !(optional = ((DataResult)featureCodec.apply(() -> configuredFeature)).result()).isPresent()) continue;
            try {
                Path cfPath = GenDataCommand.configuredFeatureJsonPath(dataPackPath, Objects.requireNonNull(featuresRegistry.func_177774_c((Object)configuredFeature)), modId);
                Files.createDirectories(cfPath.getParent(), new FileAttribute[0]);
                Files.write(cfPath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static void createConfiguredSurfaceBuilderJson(String modId, Path dataPackPath, Gson gson, Registry<ConfiguredSurfaceBuilder<?>> surfaceBuildersRegistry) {
        for (Map.Entry surfaceBuilder : surfaceBuildersRegistry.func_239659_c_()) {
            Optional optional;
            Function surfaceBuilderCodec = JsonOps.INSTANCE.withEncoder((Encoder)ConfiguredSurfaceBuilder.field_244393_b_);
            ConfiguredSurfaceBuilder configuredSurfaceBuilder = (ConfiguredSurfaceBuilder)surfaceBuilder.getValue();
            if (!((RegistryKey)surfaceBuilder.getKey()).func_240901_a_().toString().contains(modId) || configuredSurfaceBuilder == null || !Objects.requireNonNull(surfaceBuildersRegistry.func_177774_c((Object)configuredSurfaceBuilder)).toString().contains(modId) || !(optional = ((DataResult)surfaceBuilderCodec.apply(() -> configuredSurfaceBuilder)).result()).isPresent()) continue;
            try {
                Path sbPath = GenDataCommand.configuredSurfaceBuilderJsonPath(dataPackPath, Objects.requireNonNull(surfaceBuildersRegistry.func_177774_c((Object)configuredSurfaceBuilder)), modId);
                Files.createDirectories(sbPath.getParent(), new FileAttribute[0]);
                Files.write(sbPath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static void createConfiguredCarverJson(String modId, Path dataPackPath, Gson gson, Registry<ConfiguredCarver<?>> carverRegistry) {
        for (Map.Entry carver : carverRegistry.func_239659_c_()) {
            Optional optional;
            Function carverCodec = JsonOps.INSTANCE.withEncoder((Encoder)ConfiguredCarver.field_244390_b_);
            ConfiguredCarver configuredCarver = (ConfiguredCarver)carver.getValue();
            if (!((RegistryKey)carver.getKey()).func_240901_a_().toString().contains(modId) || configuredCarver == null || !Objects.requireNonNull(carverRegistry.func_177774_c((Object)configuredCarver)).toString().contains(modId) || !(optional = ((DataResult)carverCodec.apply(() -> configuredCarver)).result()).isPresent()) continue;
            try {
                Path carverPath = GenDataCommand.configuredCarverJsonPath(dataPackPath, Objects.requireNonNull(carverRegistry.func_177774_c((Object)configuredCarver)), modId);
                Files.createDirectories(carverPath.getParent(), new FileAttribute[0]);
                Files.write(carverPath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static void createConfiguredStructureJson(String modId, Path dataPackPath, Gson gson, Registry<StructureFeature<?, ?>> structureRegistry) {
        for (Map.Entry structure : structureRegistry.func_239659_c_()) {
            Optional optional;
            Function structureCodec = JsonOps.INSTANCE.withEncoder((Encoder)StructureFeature.field_244391_b_);
            StructureFeature configuredStructure = (StructureFeature)structure.getValue();
            if (!((RegistryKey)structure.getKey()).func_240901_a_().toString().contains(modId) || configuredStructure == null || !Objects.requireNonNull(structureRegistry.func_177774_c((Object)configuredStructure)).toString().contains(modId) || !(optional = ((DataResult)structureCodec.apply(() -> configuredStructure)).result()).isPresent()) continue;
            try {
                Path structurePath = GenDataCommand.configuredStructureFeatureJsonPath(dataPackPath, Objects.requireNonNull(structureRegistry.func_177774_c((Object)configuredStructure)), modId);
                Files.createDirectories(structurePath.getParent(), new FileAttribute[0]);
                Files.write(structurePath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static void createProcessorListJson(String modId, Path dataPackPath, Gson gson, Registry<StructureProcessorList> structureProcessorRegistry) {
        for (Map.Entry processor : structureProcessorRegistry.func_239659_c_()) {
            Optional optional;
            Function processorCodec = JsonOps.INSTANCE.withEncoder((Encoder)IStructureProcessorType.field_242922_m);
            StructureProcessorList processorList = (StructureProcessorList)processor.getValue();
            if (!((RegistryKey)processor.getKey()).func_240901_a_().toString().contains(modId) || processorList == null || !Objects.requireNonNull(structureProcessorRegistry.func_177774_c((Object)processorList)).toString().contains(modId) || !(optional = ((DataResult)processorCodec.apply(() -> processorList)).result()).isPresent()) continue;
            try {
                Path processorListPath = GenDataCommand.configuredProceesorListPath(dataPackPath, Objects.requireNonNull(structureProcessorRegistry.func_177774_c((Object)processorList)), modId);
                Files.createDirectories(processorListPath.getParent(), new FileAttribute[0]);
                Files.write(processorListPath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static Path worldImportJsonPath(Path path, String jsonName) {
        return path.resolve("import/" + jsonName + ".json");
    }

    private static Path configuredFeatureJsonPath(Path path, ResourceLocation identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/configured_feature/" + identifier.func_110623_a() + ".json");
    }

    private static Path configuredSurfaceBuilderJsonPath(Path path, ResourceLocation identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/configured_surface_builder/" + identifier.func_110623_a() + ".json");
    }

    private static Path configuredCarverJsonPath(Path path, ResourceLocation identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/configured_carver/" + identifier.func_110623_a() + ".json");
    }

    private static Path configuredStructureFeatureJsonPath(Path path, ResourceLocation identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/configured_structure_feature/" + identifier.func_110623_a() + ".json");
    }

    private static Path configuredProceesorListPath(Path path, ResourceLocation identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/processor_list/" + identifier.func_110623_a() + ".json");
    }

    private static Path biomeJsonPath(Path path, ResourceLocation identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/biome/" + identifier.func_110623_a() + ".json");
    }

    private static Path dataPackPath(Path path, String modId) {
        return path.resolve("gendata/" + modId + "-custom");
    }

    private static void createPackMCMeta(Path dataPackPath, String modID) throws IOException {
        String fileString = "{\n\t\"pack\":{\n\t\t\"pack_format\": 6,\n\t\t\"description\": \"Custom biome datapack for " + modID + ".\"\n\t}\n}\n";
        Files.write(dataPackPath.resolve("pack.mcmeta"), fileString.getBytes(), new OpenOption[0]);
    }

    private static /* synthetic */ void lambda$createBiomeJsonAndPackMcMeta$5(JsonArray stage, RegistryKey featureKey) {
        stage.add(featureKey.func_240901_a_().toString());
    }
}

