/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.subbiomedata;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import corgiaoc.byg.BYG;
import corgiaoc.byg.config.json.subbiomedata.SubBiomeData;
import corgiaoc.byg.config.json.subbiomedata.SubBiomeDataListHolder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SubBiomeDataListHolderSerializer
implements JsonSerializer<SubBiomeDataListHolder>,
JsonDeserializer<SubBiomeDataListHolder> {
    public static List<BiomeDictionary.Type> defaultTypesList = new ArrayList<BiomeDictionary.Type>();
    public static List<BiomeDictionary.Type> stopSpamLoggerSpam;

    public JsonElement serialize(SubBiomeDataListHolder Src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject biomes = new JsonObject();
        JsonObject biomeObject = new JsonObject();
        for (SubBiomeData biomeData : Src.getSubBiomeData()) {
            JsonObject object = new JsonObject();
            StringBuilder dictionaryString = new StringBuilder();
            for (BiomeDictionary.Type type : biomeData.getDictionaryTypes()) {
                if (!dictionaryString.toString().isEmpty()) {
                    dictionaryString.append(",");
                }
                dictionaryString.append(type.toString());
            }
            object.addProperty("dictionary", dictionaryString.toString().toUpperCase());
            ResourceLocation riverKey = WorldGenRegistries.field_243657_i.func_177774_c((Object)biomeData.getRiverBiome());
            if (riverKey != null) {
                object.addProperty("river", riverKey.toString());
            } else {
                object.addProperty("river", "");
            }
            ResourceLocation beachKey = WorldGenRegistries.field_243657_i.func_177774_c((Object)biomeData.getBeachBiome());
            if (beachKey != null) {
                object.addProperty("beach", beachKey.toString());
            } else {
                object.addProperty("beach", "");
            }
            ResourceLocation edgeKey = WorldGenRegistries.field_243657_i.func_177774_c((Object)biomeData.getEdgeBiome());
            if (edgeKey != null) {
                object.addProperty("edge", edgeKey.toString());
            } else {
                object.addProperty("edge", "");
            }
            ResourceLocation location = WorldGenRegistries.field_243657_i.func_177774_c((Object)biomeData.getBiome());
            if (location != null) {
                biomeObject.add(location.toString(), (JsonElement)object);
                continue;
            }
            BYG.LOGGER.error("The Biome key was null! This should NEVER happen.");
        }
        biomes.add("sub-biomes", (JsonElement)biomeObject);
        return biomes;
    }

    public SubBiomeDataListHolder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BYG.LOGGER.info("Reading Sub-Biomes json");
        JsonObject jsonObject = json.getAsJsonObject();
        ArrayList<SubBiomeData> biomeData = new ArrayList<SubBiomeData>();
        Set entrySet = jsonObject.get("sub-biomes").getAsJsonObject().entrySet();
        for (Map.Entry elementEntry : entrySet) {
            String biomeName = (String)elementEntry.getKey();
            JsonElement element = (JsonElement)elementEntry.getValue();
            JsonObject elementObject = element.getAsJsonObject();
            String edge = elementObject.get("edge").getAsString();
            String river = elementObject.get("river").getAsString();
            String beach = elementObject.get("beach").getAsString();
            String dictionary = elementObject.get("dictionary").getAsString();
            List<BiomeDictionary.Type> types = Arrays.stream(dictionary.trim().replace(" ", "").toUpperCase().split(",")).map(this::warnIfTagIsNotDefault).map(x$0 -> BiomeDictionary.Type.getType((String)x$0, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toList());
            BiomeDictionary.Type[] typesArray = new BiomeDictionary.Type[types.size()];
            typesArray = types.toArray(typesArray);
            if (types.size() == 0) {
                types.add(BiomeDictionary.Type.OVERWORLD);
                BYG.LOGGER.warn("No dictionary entries were read...defaulting to: \"OVERWORLD\"");
            }
            ResourceLocation biomeKey = new ResourceLocation(biomeName);
            if (WorldGenRegistries.field_243657_i.func_148742_b().contains(biomeKey)) {
                if (biomeKey.func_110624_b().equals("byg")) {
                    biomeData.add(new SubBiomeData((Biome)WorldGenRegistries.field_243657_i.func_82594_a(biomeKey), typesArray, (Biome)WorldGenRegistries.field_243657_i.func_82594_a(new ResourceLocation(edge)), (Biome)WorldGenRegistries.field_243657_i.func_82594_a(new ResourceLocation(beach)), (Biome)WorldGenRegistries.field_243657_i.func_82594_a(new ResourceLocation(river))));
                    continue;
                }
                BYG.LOGGER.error("Biome key: \"" + biomeName + "\" is illegal. The mod id for the biome key MUST be \"byg\". Skipping entry...");
                continue;
            }
            BYG.LOGGER.error("The biome key: \"" + biomeName + "\" was not found in the registry, skipping entry...");
        }
        return new SubBiomeDataListHolder(biomeData);
    }

    public String warnIfTagIsNotDefault(String string) {
        BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
        if (!defaultTypesList.contains(type) && !stopSpamLoggerSpam.contains(type)) {
            BYG.LOGGER.warn(type.toString() + " is not a default dictionary value.\nIgnore this msg if using modded biome dictionary values.");
            stopSpamLoggerSpam.add(type);
        }
        return string;
    }

    static {
        defaultTypesList.add(BiomeDictionary.Type.HOT);
        defaultTypesList.add(BiomeDictionary.Type.COLD);
        defaultTypesList.add(BiomeDictionary.Type.SPARSE);
        defaultTypesList.add(BiomeDictionary.Type.DENSE);
        defaultTypesList.add(BiomeDictionary.Type.WET);
        defaultTypesList.add(BiomeDictionary.Type.DRY);
        defaultTypesList.add(BiomeDictionary.Type.SAVANNA);
        defaultTypesList.add(BiomeDictionary.Type.CONIFEROUS);
        defaultTypesList.add(BiomeDictionary.Type.JUNGLE);
        defaultTypesList.add(BiomeDictionary.Type.SPOOKY);
        defaultTypesList.add(BiomeDictionary.Type.DEAD);
        defaultTypesList.add(BiomeDictionary.Type.LUSH);
        defaultTypesList.add(BiomeDictionary.Type.MUSHROOM);
        defaultTypesList.add(BiomeDictionary.Type.MAGICAL);
        defaultTypesList.add(BiomeDictionary.Type.RARE);
        defaultTypesList.add(BiomeDictionary.Type.PLATEAU);
        defaultTypesList.add(BiomeDictionary.Type.MODIFIED);
        defaultTypesList.add(BiomeDictionary.Type.OCEAN);
        defaultTypesList.add(BiomeDictionary.Type.RIVER);
        defaultTypesList.add(BiomeDictionary.Type.WATER);
        defaultTypesList.add(BiomeDictionary.Type.MESA);
        defaultTypesList.add(BiomeDictionary.Type.FOREST);
        defaultTypesList.add(BiomeDictionary.Type.PLAINS);
        defaultTypesList.add(BiomeDictionary.Type.MOUNTAIN);
        defaultTypesList.add(BiomeDictionary.Type.HILLS);
        defaultTypesList.add(BiomeDictionary.Type.SWAMP);
        defaultTypesList.add(BiomeDictionary.Type.BEACH);
        defaultTypesList.add(BiomeDictionary.Type.SANDY);
        defaultTypesList.add(BiomeDictionary.Type.SNOWY);
        defaultTypesList.add(BiomeDictionary.Type.WASTELAND);
        defaultTypesList.add(BiomeDictionary.Type.VOID);
        defaultTypesList.add(BiomeDictionary.Type.OVERWORLD);
        defaultTypesList.add(BiomeDictionary.Type.NETHER);
        defaultTypesList.add(BiomeDictionary.Type.END);
        stopSpamLoggerSpam = new ArrayList<BiomeDictionary.Type>();
    }
}

