/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.biomedata;

import corgiaoc.byg.common.world.biome.BYGBiome;
import corgiaoc.byg.config.json.biomedata.BiomeData;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeDataListHolder {
    List<BiomeData> biomeData;

    public BiomeDataListHolder(List<BiomeData> biomeData) {
        this.biomeData = biomeData;
    }

    public List<BiomeData> getBiomeData() {
        return this.biomeData;
    }

    public static void createDefaults() {
        for (BYGBiome bygBiome : BYGBiome.BYG_BIOMES) {
            List<BiomeDictionary.Type> typeList = Arrays.asList(bygBiome.getBiomeDictionary());
            typeList.sort(Comparator.comparing(Object::toString));
            BYGBiome.biomeData.add(new BiomeData(bygBiome.getBiome(), bygBiome.getWeight(), bygBiome.getBiomeType(), typeList.toArray(new BiomeDictionary.Type[0]), bygBiome.getHills(), bygBiome.getEdge(), bygBiome.getBeach(), bygBiome.getRiver()));
        }
        BYGBiome.biomeData.sort(Comparator.comparing(data -> WorldGenRegistries.field_243657_i.func_177774_c((Object)data.getBiome()).toString()));
    }

    public static void fillBiomeLists() {
        for (BiomeData biomeData : BYGBiome.biomeData) {
            if (biomeData.getBiomeWeightedList() != null) {
                BYGBiome.BIOME_TO_HILLS_LIST.put(WorldGenRegistries.field_243657_i.func_148757_b((Object)biomeData.getBiome()), biomeData.getBiomeWeightedList());
            }
            if (biomeData.getBeachBiome() != null) {
                BYGBiome.BIOME_TO_BEACH_LIST.put(WorldGenRegistries.field_243657_i.func_148757_b((Object)biomeData.getBiome()), (Object)biomeData.getBeachBiome());
            }
            if (biomeData.getEdgeBiome() != null) {
                BYGBiome.BIOME_TO_EDGE_LIST.put(WorldGenRegistries.field_243657_i.func_148757_b((Object)biomeData.getBiome()), (Object)biomeData.getEdgeBiome());
            }
            if (biomeData.getRiverBiome() == null) continue;
            BYGBiome.BIOME_TO_RIVER_LIST.put(WorldGenRegistries.field_243657_i.func_148757_b((Object)biomeData.getBiome()), (Object)biomeData.getRiverBiome());
        }
        BYGBiome.BIOME_TO_EDGE_LIST.remove(-1);
        BYGBiome.BIOME_TO_BEACH_LIST.remove(-1);
        BYGBiome.BIOME_TO_RIVER_LIST.remove(-1);
    }
}

