/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.surfacebuilder;

import com.mojang.serialization.Codec;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class BasaltBarreraSB
extends SurfaceBuilder<SurfaceBuilderConfig> {
    public static FastNoise noiseGen = null;
    public static FastNoise simplexGen = null;

    public BasaltBarreraSB(Codec<SurfaceBuilderConfig> codec) {
        super(codec);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.func_205548_a(seed);
        int xPos = x & 0xF;
        int zPos = z & 0xF;
        BlockPos.Mutable mutable = new BlockPos.Mutable(xPos, 0, zPos);
        float sampleNoise = noiseGen.GetNoise(x, z);
        float simplexNoise = simplexGen.GetNoise(x, z);
        int groundLevel = chunkIn.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z);
        int topHeight = simplexNoise > 0.0f ? Math.abs((int)(sampleNoise * 2.0f) * 2) + groundLevel : Math.abs((int)(sampleNoise * 2.0f)) + groundLevel;
        mutable.func_189534_c(Direction.UP, topHeight);
        for (int y = Math.abs(topHeight); y >= groundLevel - 2; --y) {
            chunkIn.func_177436_a((BlockPos)mutable, Blocks.field_235337_cO_.func_176223_P(), false);
            mutable.func_189536_c(Direction.DOWN);
        }
    }

    public void func_205548_a(long seed) {
        if (noiseGen == null) {
            noiseGen = new FastNoise((int)seed);
            noiseGen.SetNoiseType(FastNoise.NoiseType.WhiteNoise);
            noiseGen.SetFractalOctaves(1);
            noiseGen.SetFrequency(0.002f);
        }
        if (simplexGen == null) {
            simplexGen = new FastNoise((int)seed);
            simplexGen.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            simplexGen.SetFractalOctaves(3);
            simplexGen.SetFrequency(0.009f);
        }
    }
}

