/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.trees.holly;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.BYGTreeConfig;
import corgiaoc.byg.common.world.feature.overworld.trees.util.BYGAbstractTreeFeature;
import corgiaoc.byg.core.BYGBlocks;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;

public class HollyTree4
extends BYGAbstractTreeFeature<BYGTreeConfig> {
    public HollyTree4(Codec<BYGTreeConfig> configIn) {
        super(configIn);
    }

    @Override
    protected boolean generate(Set<BlockPos> changedBlocks, ISeedReader worldIn, Random rand, BlockPos pos, MutableBoundingBox boundsIn, boolean isSapling, BYGTreeConfig config) {
        int randTreeHeight = config.getMinHeight() + rand.nextInt(config.getMaxPossibleHeight());
        BlockPos.Mutable mainmutable = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        if (pos.func_177956_o() + randTreeHeight + 1 < worldIn.func_217301_I()) {
            if (!HollyTree4.isDesiredGroundwDirtTag((IWorldGenerationBaseReader)worldIn, pos.func_177977_b(), config)) {
                return false;
            }
            if (!this.isAnotherTreeNearby((IWorldGenerationBaseReader)worldIn, pos, randTreeHeight, 0, isSapling)) {
                return false;
            }
            if (!this.doesSaplingHaveSpaceToGrow((IWorldGenerationBaseReader)worldIn, pos, randTreeHeight, 5, 5, 5, isSapling, new BlockPos[0])) {
                return false;
            }
            this.buildTrunkBase(pos, changedBlocks, worldIn, config, rand, boundsIn, mainmutable.func_189533_g((Vector3i)pos).func_185334_h());
            mainmutable.func_189533_g((Vector3i)pos);
            for (int buildTrunk = 0; buildTrunk <= randTreeHeight; ++buildTrunk) {
                this.placeTrunk(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable, boundsIn);
                mainmutable.func_189536_c(Direction.UP);
            }
            mainmutable.func_189533_g((Vector3i)pos);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight - 5, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 4, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight - 4, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 4, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 4, 2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 3, -3), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 3, -2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-2, randTreeHeight - 3, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight - 3, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight - 3, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight - 3, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(2, randTreeHeight - 3, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight - 3, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 3, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight - 3, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(2, randTreeHeight - 3, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 2, -2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight - 2, -2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-2, randTreeHeight - 2, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight - 2, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(2, randTreeHeight - 2, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-2, randTreeHeight - 2, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight - 2, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight - 2, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-2, randTreeHeight - 2, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 2, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight - 2, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(2, randTreeHeight - 2, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 2, 2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 1, -2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(2, randTreeHeight - 1, -2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight - 1, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 1, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight - 1, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(2, randTreeHeight - 1, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-2, randTreeHeight - 1, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight - 1, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight - 1, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight - 1, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 1, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight - 1, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 1, 2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight - 1, 2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight - 1, 3), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight, -2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight, -2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-2, randTreeHeight, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-2, randTreeHeight, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(2, randTreeHeight, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-2, randTreeHeight, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(2, randTreeHeight, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight, 2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight + 1, -2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight + 1, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight + 1, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight + 1, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-2, randTreeHeight + 1, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight + 1, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight + 1, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight + 1, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(2, randTreeHeight + 1, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight + 1, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight + 1, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight + 1, 2), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight + 2, -1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight + 2, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight + 2, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(1, randTreeHeight + 2, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight + 2, 1), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(-1, randTreeHeight + 3, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight + 3, 0), boundsIn);
            this.placeLeaves(config, rand, changedBlocks, worldIn, (BlockPos)mainmutable.func_189533_g((Vector3i)pos).func_196234_d(0, randTreeHeight + 4, 0), boundsIn);
        }
        return true;
    }

    private void treeLog(Set<BlockPos> setlogblock, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (HollyTree4.canLogPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlocks.HOLLY_LOG.func_176223_P(), boundingBox);
        }
    }

    private void treeBranch(Set<BlockPos> setlogblock, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (HollyTree4.canLogPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(setlogblock, (IWorldWriter)reader, pos, BYGBlocks.HOLLY_LOG.func_176223_P(), boundingBox);
        }
    }

    private void leafs(Set<BlockPos> blockPos, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        BlockPos.Mutable blockpos = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        if (HollyTree4.isAir((IWorldGenerationBaseReader)reader, (BlockPos)blockpos)) {
            this.setFinalBlockState(blockPos, (IWorldWriter)reader, (BlockPos)blockpos, this.randomLeaves(), boundingBox);
        }
    }

    public BlockState randomLeaves() {
        Random random = new Random();
        int randomizer = random.nextInt(25);
        if (randomizer == 1) {
            return BYGBlocks.HOLLY_BERRY_LEAVES.func_176223_P();
        }
        if (randomizer == 0) {
            return BYGBlocks.HOLLY_LEAVES.func_176223_P();
        }
        return BYGBlocks.HOLLY_LEAVES.func_176223_P();
    }

    private boolean doesTreeFit(IWorldGenerationBaseReader reader, BlockPos blockPos, int height) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
            int distance = 0;
            for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                    if (HollyTree4.canLogPlaceHere(reader, (BlockPos)pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

