/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.nether;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.HangingColumnWithBaseConfig;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class HangingColumnWithBase
extends Feature<HangingColumnWithBaseConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public HangingColumnWithBase(Codec<HangingColumnWithBaseConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, HangingColumnWithBaseConfig config) {
        if (!world.func_175623_d(pos)) {
            return false;
        }
        BlockState blockstate = world.func_180495_p(pos.func_177984_a());
        if (!config.getWhitelist().contains(blockstate.func_177230_c())) {
            return false;
        }
        this.generateBase((IWorld)world, rand, pos, config);
        this.generateVinesInArea((IWorld)world, rand, pos, config);
        return true;
    }

    private void generateBase(IWorld world, Random rand, BlockPos pos, HangingColumnWithBaseConfig config) {
        world.func_180501_a(pos, config.getBaseBlockProvider().func_225574_a_(rand, pos), 2);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        BlockPos.Mutable mutable2 = new BlockPos.Mutable();
        for (int i = 0; i < 200; ++i) {
            mutable.func_239621_a_((Vector3i)pos, rand.nextInt(6) - rand.nextInt(6), rand.nextInt(2) - rand.nextInt(5), rand.nextInt(6) - rand.nextInt(6));
            if (!world.func_175623_d((BlockPos)mutable)) continue;
            int j = 0;
            for (Direction direction : DIRECTIONS) {
                BlockState blockstate = world.func_180495_p((BlockPos)mutable2.func_239622_a_((Vector3i)mutable, direction));
                if (config.getWhitelist().contains(blockstate.func_177230_c())) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            world.func_180501_a((BlockPos)mutable, config.getBaseBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
        }
    }

    private void generateVinesInArea(IWorld world, Random rand, BlockPos pos, HangingColumnWithBaseConfig config) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int i = 0; i < 100; ++i) {
            mutable.func_239621_a_((Vector3i)pos, rand.nextInt(8) - rand.nextInt(8), rand.nextInt(2) - rand.nextInt(7), rand.nextInt(8) - rand.nextInt(8));
            if (!world.func_175623_d((BlockPos)mutable)) continue;
            BlockState blockstate = world.func_180495_p(mutable.func_177984_a());
            if (!config.getWhitelist().contains(blockstate.func_177230_c())) continue;
            int length = MathHelper.func_76136_a((Random)rand, (int)config.getMinLength(), (int)config.getMaxLength());
            if (rand.nextInt(6) == 0) {
                length *= 2;
            }
            if (rand.nextInt(5) == 0) {
                length = 1;
            }
            HangingColumnWithBase.generateLength(world, mutable, length, rand, config);
        }
    }

    public static void generateLength(IWorld world, BlockPos.Mutable mutable, int length, Random rand, HangingColumnWithBaseConfig config) {
        for (int i = 0; i <= length; ++i) {
            if (world.func_175623_d((BlockPos)mutable)) {
                if (i == length || !world.func_175623_d(mutable.func_177977_b())) {
                    world.func_180501_a((BlockPos)mutable, config.getEndBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                    break;
                }
                world.func_180501_a((BlockPos)mutable, config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
            }
            mutable.func_189536_c(Direction.DOWN);
        }
    }
}

