/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.core;

import com.minecraftabnormals.abnormals_core.core.util.registry.ISubRegistryHelper;
import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import com.minecraftabnormals.upgrade_aquatic.client.GlowSquidSpriteUploader;
import com.minecraftabnormals.upgrade_aquatic.client.particle.UAParticles;
import com.minecraftabnormals.upgrade_aquatic.common.network.RotateJellyfishMessage;
import com.minecraftabnormals.upgrade_aquatic.core.config.Config;
import com.minecraftabnormals.upgrade_aquatic.core.config.ConfigHelper;
import com.minecraftabnormals.upgrade_aquatic.core.other.UAClientCompat;
import com.minecraftabnormals.upgrade_aquatic.core.other.UACompat;
import com.minecraftabnormals.upgrade_aquatic.core.other.UADataSerializers;
import com.minecraftabnormals.upgrade_aquatic.core.other.UADispenseBehaviorRegistry;
import com.minecraftabnormals.upgrade_aquatic.core.other.UASpawns;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAEffects;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAEntities;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAFeatures;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAItems;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UATileEntities;
import com.minecraftabnormals.upgrade_aquatic.core.registry.util.UAItemSubRegistryHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="upgrade_aquatic")
public class UpgradeAquatic {
    public static UpgradeAquatic instance;
    public static final String NETWORK_PROTOCOL = "1";
    public static final String MODID = "upgrade_aquatic";
    public static final RegistryHelper REGISTRY_HELPER;
    public static final SimpleChannel CHANNEL;

    public UpgradeAquatic() {
        instance = this;
        this.setupMessages();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setupCommon);
        REGISTRY_HELPER.register(modEventBus);
        UAEffects.EFFECTS.register(modEventBus);
        UAEffects.POTIONS.register(modEventBus);
        UAFeatures.FEATURES.register(modEventBus);
        UAParticles.PARTICLES.register(modEventBus);
        UADataSerializers.SERIALIZERS.register(modEventBus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(EventPriority.LOWEST, this::setupClient);
            GlowSquidSpriteUploader.init(modEventBus);
        });
        modEventBus.addListener(event -> {
            ModConfig config = event.getConfig();
            if (config.getSpec() == Config.CLIENTSPEC) {
                ConfigHelper.updateClientConfig(config);
            }
        });
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, Config.CLIENTSPEC);
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            UACompat.registerCompat();
            UAEntities.registerAttributes();
            UASpawns.registerSpawns();
            UAEffects.registerBrewingRecipes();
            UADispenseBehaviorRegistry.registerDispenseBehaviors();
            UAFeatures.Configured.registerConfiguredFeatures();
            ObfuscationReflectionHelper.setPrivateValue(AbstractBlock.class, (Object)Blocks.field_203203_C, (Object)true, (String)"field_149789_z");
        });
    }

    private void setupClient(FMLClientSetupEvent event) {
        UAEntities.registerRenderers();
        UATileEntities.registerRenderers();
        event.enqueueWork(() -> {
            UAItems.setupItemPropertes();
            UAClientCompat.registerClientCompat();
        });
    }

    void setupMessages() {
        int id = -1;
        CHANNEL.messageBuilder(RotateJellyfishMessage.class, id++).encoder(RotateJellyfishMessage::serialize).decoder(RotateJellyfishMessage::deserialize).consumer(RotateJellyfishMessage::handle).add();
    }

    static {
        REGISTRY_HELPER = RegistryHelper.create((String)MODID, helper -> helper.putSubHelper(ForgeRegistries.ITEMS, (ISubRegistryHelper)new UAItemSubRegistryHelper((RegistryHelper)helper)));
        CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "net")).networkProtocolVersion(() -> NETWORK_PROTOCOL).clientAcceptedVersions(NETWORK_PROTOCOL::equals).serverAcceptedVersions(NETWORK_PROTOCOL::equals).simpleChannel();
    }
}

