/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.common.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public final class VoxelShapeHelper {
    private VoxelShapeHelper() {
    }

    public static VoxelShape makeCuboidShape(double x1, double y1, double z1, double x2, double y2, double z2, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return VoxelShapeHelper.makeCuboidShape(x1, y1, z1, x2, y2, z2, Direction.EAST);
            }
            case Y: {
                return VoxelShapeHelper.makeCuboidShape(x1, y1, z1, x2, y2, z2, Direction.UP);
            }
            case Z: {
                return VoxelShapeHelper.makeCuboidShape(x1, y1, z1, x2, y2, z2, Direction.SOUTH);
            }
        }
        throw new IllegalStateException("Unexpected value: " + axis);
    }

    public static VoxelShape makeCuboidShape(double x1, double y1, double z1, double x2, double y2, double z2, Direction direction) {
        switch (direction) {
            case UP: {
                return Block.func_208617_a((double)x1, (double)z1, (double)y1, (double)x2, (double)z2, (double)y2);
            }
            case DOWN: {
                return Block.func_208617_a((double)x1, (double)(16.0 - z1), (double)y1, (double)x2, (double)(16.0 - z2), (double)y2);
            }
            case NORTH: {
                return Block.func_208617_a((double)(16.0 - x1), (double)y1, (double)(16.0 - z2), (double)(16.0 - x2), (double)y2, (double)(16.0 - z1));
            }
            case EAST: {
                return Block.func_208617_a((double)z1, (double)y1, (double)(16.0 - x1), (double)z2, (double)y2, (double)(16.0 - x2));
            }
            case SOUTH: {
                return Block.func_208617_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }
            case WEST: {
                return Block.func_208617_a((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            }
        }
        throw new IllegalStateException("Unexpected value: " + direction);
    }

    public static final class Builder {
        private final Set<VoxelShape> shapes;

        public Builder() {
            this.shapes = new HashSet<VoxelShape>();
        }

        public Builder(Builder other) {
            this.shapes = new HashSet<VoxelShape>(other.shapes);
        }

        private Builder transformRaw(Function<AxisAlignedBB, VoxelShape> transformer) {
            Builder newBuilder = new Builder();
            for (VoxelShape shape : this.shapes) {
                HashSet<VoxelShape> rotatedShapes = new HashSet<VoxelShape>();
                for (AxisAlignedBB box : shape.func_197756_d()) {
                    rotatedShapes.add(transformer.apply(box));
                }
                VoxelShape result = VoxelShapes.func_197880_a();
                for (VoxelShape rotatedShape : rotatedShapes) {
                    result = VoxelShapes.func_197882_b((VoxelShape)result, (VoxelShape)rotatedShape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                }
                newBuilder.append(result.func_197753_c());
            }
            return newBuilder;
        }

        public Builder append(VoxelShape ... shapes) {
            this.shapes.addAll(Arrays.asList(shapes));
            return this;
        }

        public Builder append(Builder other) {
            this.shapes.addAll(other.shapes);
            return this;
        }

        public Builder translate(double x, double y, double z) {
            return this.transformRaw(box -> Block.func_208617_a((double)(box.field_72340_a * 16.0 + x), (double)(box.field_72338_b * 16.0 + y), (double)(box.field_72339_c * 16.0 + z), (double)(box.field_72336_d * 16.0 + x), (double)(box.field_72337_e * 16.0 + y), (double)(box.field_72334_f * 16.0 + z)));
        }

        public Builder rotate(Direction.Axis axis) {
            return this.transformRaw(box -> VoxelShapeHelper.makeCuboidShape(box.field_72340_a * 16.0, box.field_72338_b * 16.0, box.field_72339_c * 16.0, box.field_72336_d * 16.0, box.field_72337_e * 16.0, box.field_72334_f * 16.0, axis));
        }

        public Builder rotate(Direction direction) {
            return this.transformRaw(box -> VoxelShapeHelper.makeCuboidShape(box.field_72340_a * 16.0, box.field_72338_b * 16.0, box.field_72339_c * 16.0, box.field_72336_d * 16.0, box.field_72337_e * 16.0, box.field_72334_f * 16.0, direction));
        }

        public Builder scale(double x, double y, double z) {
            return this.transformRaw(box -> Block.func_208617_a((double)(box.field_72340_a * 16.0 * x), (double)(box.field_72338_b * 16.0 * y), (double)(box.field_72339_c * 16.0 * z), (double)(box.field_72336_d * 16.0 * x), (double)(box.field_72337_e * 16.0 * y), (double)(box.field_72334_f * 16.0 * z)));
        }

        public VoxelShape build() {
            return this.build(IBooleanFunction.field_223244_o_);
        }

        public VoxelShape build(IBooleanFunction combineFunction) {
            if (this.shapes.isEmpty()) {
                return VoxelShapes.func_197880_a();
            }
            VoxelShape result = VoxelShapes.func_197880_a();
            for (VoxelShape shape : this.shapes) {
                result = VoxelShapes.func_197882_b((VoxelShape)result, (VoxelShape)shape, (IBooleanFunction)combineFunction);
            }
            return result.func_197753_c();
        }
    }
}

