/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.common.item;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class SpawnEggItemBase<T extends EntityType<?>>
extends SpawnEggItem {
    private final boolean addToMisc;
    private final Supplier<T> type;

    public SpawnEggItemBase(Supplier<T> type, int primaryColor, int secondaryColor, boolean addToMisc, Item.Properties builder) {
        super(null, primaryColor, secondaryColor, builder);
        this.type = type;
        this.addToMisc = addToMisc;
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, EventPriority.LOWEST, this::onEvent);
    }

    private void onEvent(RegistryEvent.Register<EntityType<?>> event) {
        Map eggs = (Map)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, (Object)((Object)this), (String)"field_195987_b");
        if (eggs == null) {
            throw new RuntimeException("Failed to inject spawns eggs");
        }
        eggs.put(this.type.get(), this);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.addToMisc) {
            super.func_150895_a(group, items);
            return;
        }
        if (this.func_194125_a(group) || group == ItemGroup.field_78026_f) {
            Optional<ItemStack> optional;
            if (items.stream().anyMatch(stack -> stack.func_77973_b() instanceof SpawnEggItem) && (optional = items.stream().filter(stack -> stack.func_77973_b() instanceof SpawnEggItem && "minecraft".equals(Objects.requireNonNull(stack.func_77973_b().getRegistryName()).func_110624_b())).reduce((a, b) -> b)).isPresent() && items.contains((Object)optional.get())) {
                items.add(items.indexOf((Object)optional.get()) + 1, (Object)new ItemStack((IItemProvider)this));
                return;
            }
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    public EntityType<?> func_208076_b(@Nullable CompoundNBT p_208076_1_) {
        CompoundNBT compoundnbt;
        if (p_208076_1_ != null && p_208076_1_.func_150297_b("EntityTag", 10) && (compoundnbt = p_208076_1_.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return (EntityType)EntityType.func_220327_a((String)compoundnbt.func_74779_i("id")).orElseGet(this.type);
        }
        return (EntityType)this.type.get();
    }
}

