/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.client.tooltip;

import io.github.ocelot.sonar.client.tooltip.TooltipColor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TooltipColorManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, ResourceLocation> RESOURCE_CACHE = new WeakHashMap<String, ResourceLocation>();
    private static final Map<String, Integer> COLOR_CACHE = new WeakHashMap<String, Integer>();
    private static final Set<String> ERRORED_COLOR_CACHE = new HashSet<String>();
    public static IForgeRegistry<TooltipColor.RegistryWrapper> TOOLTIP_COLORS;

    public static void register(IEventBus bus) {
        bus.addListener(TooltipColorManager::registerRegistries);
        MinecraftForge.EVENT_BUS.register(TooltipColorManager.class);
    }

    private static void registerRegistries(RegistryEvent.NewRegistry event) {
        TOOLTIP_COLORS = new RegistryBuilder().setName(new ResourceLocation("sonar", "tooltip_colors")).setType(TooltipColor.RegistryWrapper.class).create();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onEvent(RenderTooltipEvent.Color event) {
        ItemStack stack = event.getStack();
        int borderStartColor = TooltipColorManager.getBorderStartColor(stack);
        int borderEndColor = TooltipColorManager.getBorderEndColor(stack);
        int backgroundColor = TooltipColorManager.getBackgroundColor(stack);
        if (borderStartColor != 0) {
            event.setBorderStart(borderStartColor);
        }
        if (borderEndColor != 0) {
            event.setBorderEnd(borderEndColor);
        }
        if (backgroundColor != 0) {
            event.setBackground(backgroundColor);
        }
    }

    @Nullable
    private static TooltipColor getTooltipColor(CompoundNBT nbt) {
        return nbt.func_150297_b("Color", 8) ? (TooltipColor)TOOLTIP_COLORS.getValue(RESOURCE_CACHE.computeIfAbsent(nbt.func_74779_i("Color"), ResourceLocation::new)) : null;
    }

    private static int getColor(CompoundNBT nbt, String name, int defaultColor) {
        if (nbt.func_150297_b(name, 8)) {
            String number = nbt.func_74779_i(name);
            if (ERRORED_COLOR_CACHE.contains(number)) {
                return defaultColor;
            }
            if (COLOR_CACHE.containsKey(number)) {
                return COLOR_CACHE.get(number);
            }
            try {
                int color = NumberUtils.createNumber((String)number).intValue();
                COLOR_CACHE.put(number, color);
                return color;
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse tooltip color '" + name + "' as hex", (Throwable)e);
                ERRORED_COLOR_CACHE.add(number);
                return 0;
            }
        }
        if (nbt.func_150297_b(name, 99)) {
            return nbt.func_74762_e(name);
        }
        return defaultColor;
    }

    public static int getBorderStartColor(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("Tooltip");
        if (nbt == null) {
            return 0;
        }
        TooltipColor tooltipColor = TooltipColorManager.getTooltipColor(nbt);
        int borderColor = TooltipColorManager.getColor(nbt, "BorderColor", 0);
        return TooltipColorManager.getColor(nbt, "BorderStartColor", borderColor != 0 ? borderColor : (tooltipColor != null ? tooltipColor.getBorderStartColor() : 0));
    }

    public static int getBorderEndColor(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("Tooltip");
        if (nbt == null) {
            return 0;
        }
        TooltipColor tooltipColor = TooltipColorManager.getTooltipColor(nbt);
        int borderColor = TooltipColorManager.getColor(nbt, "BorderColor", 0);
        return TooltipColorManager.getColor(nbt, "BorderEndColor", borderColor != 0 ? borderColor : (tooltipColor != null ? tooltipColor.getBorderStartColor() : 0));
    }

    public static int getBackgroundColor(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("Tooltip");
        if (nbt == null) {
            return 0;
        }
        TooltipColor tooltipColor = TooltipColorManager.getTooltipColor(nbt);
        return TooltipColorManager.getColor(nbt, "BackgroundColor", tooltipColor != null ? tooltipColor.getBackgroundColor() : 0);
    }
}

