/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class DataUtil {
    private static final Method ADD_MIX_METHOD = ObfuscationReflectionHelper.findMethod(PotionBrewing.class, (String)"func_193357_a", (Class[])new Class[]{Potion.class, Item.class, Potion.class});

    public static void registerFlammable(Block block, int encouragement, int flammability) {
        FireBlock fire = (FireBlock)Blocks.field_150480_ab;
        fire.func_180686_a(block, encouragement, flammability);
    }

    public static void registerCompostable(IItemProvider item, float chance) {
        ComposterBlock.field_220299_b.put((Object)item.func_199767_j(), chance);
    }

    public static void addMix(Potion input, Item reactant, Potion result) {
        try {
            ADD_MIX_METHOD.invoke(null, input, reactant, result);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to add mix for " + result.getRegistryName() + " from " + reactant.getRegistryName(), e);
        }
    }

    public static void registerBlockColor(BlockColors blockColors, IBlockColor color, List<RegistryObject<Block>> blocksIn) {
        blocksIn.removeIf(block -> !block.isPresent());
        if (blocksIn.size() > 0) {
            Block[] blocks = new Block[blocksIn.size()];
            for (int i = 0; i < blocksIn.size(); ++i) {
                blocks[i] = (Block)blocksIn.get(i).get();
            }
            blockColors.func_186722_a(color, blocks);
        }
    }

    public static void registerBlockItemColor(ItemColors blockColors, IItemColor color, List<RegistryObject<Block>> blocksIn) {
        blocksIn.removeIf(block -> !block.isPresent());
        if (blocksIn.size() > 0) {
            Block[] blocks = new Block[blocksIn.size()];
            for (int i = 0; i < blocksIn.size(); ++i) {
                blocks[i] = (Block)blocksIn.get(i).get();
            }
            blockColors.func_199877_a(color, (IItemProvider[])blocks);
        }
    }

    public static EnchantmentType[] add(EnchantmentType[] array, EnchantmentType element) {
        int arrayLength = Array.getLength(array);
        Object newArrayObject = Array.newInstance(array.getClass().getComponentType(), arrayLength + 1);
        System.arraycopy(array, 0, newArrayObject, 0, arrayLength);
        array[array.length - 1] = element;
        return array;
    }

    public static boolean matchesKeys(ResourceLocation loc, RegistryKey<?> ... keys) {
        for (RegistryKey<?> key : keys) {
            if (!key.func_240901_a_().equals((Object)loc)) continue;
            return true;
        }
        return false;
    }

    public static void registerAlternativeDispenseBehavior(Item item, BiPredicate<IBlockSource, ItemStack> condition, IDispenseItemBehavior newBehavior) {
        IDispenseItemBehavior oldBehavior = (IDispenseItemBehavior)DispenserBlock.field_149943_a.get(item);
        DispenserBlock.func_199774_a((IItemProvider)item, (source, stack) -> condition.test(source, stack) ? newBehavior.dispense(source, stack) : oldBehavior.dispense(source, stack));
    }

    public static void addToJigsawPattern(ResourceLocation toAdd, JigsawPiece newPiece, int weight) {
        JigsawPattern oldPool = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(toAdd);
        if (oldPool != null) {
            oldPool.field_214952_d.add(Pair.of((Object)newPiece, (Object)weight));
            List jigsawPieces = oldPool.field_214953_e;
            for (int i = 0; i < weight; ++i) {
                jigsawPieces.add(newPiece);
            }
        }
    }
}

