/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.endimator.entity;

import com.minecraftabnormals.abnormals_core.core.endimator.entity.EndimatorEntityModel;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EndimatorModelRenderer
extends ModelRenderer {
    public float defaultRotationPointX;
    public float defaultRotationPointY;
    public float defaultRotationPointZ;
    public float defaultRotateAngleX;
    public float defaultRotateAngleY;
    public float defaultRotateAngleZ;
    public float defaultOffsetX;
    public float defaultOffsetY;
    public float defaultOffsetZ;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float defaultScaleX;
    public float defaultScaleY;
    public float defaultScaleZ;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    public int field_78803_o;
    public int field_78813_p;
    public float field_78801_a;
    public float field_78799_b;
    public boolean scaleChildren = true;
    private String name;
    private final ObjectList<ModelBox> cubeList = new ObjectArrayList();
    private final ObjectList<EndimatorModelRenderer> childModels = new ObjectArrayList();

    public EndimatorModelRenderer(EndimatorEntityModel<? extends Entity> model) {
        super(model);
        this.setScale(1.0f, 1.0f, 1.0f);
        model.addBoxToSavedBoxes(this);
        model.accept(this);
        this.setTextureSize(model.field_78090_t, model.field_78089_u);
    }

    public EndimatorModelRenderer(EndimatorEntityModel<? extends Entity> model, int textureOffsetX, int textureOffsetY) {
        this(model.field_78090_t, model.field_78089_u, textureOffsetX, textureOffsetY);
        model.addBoxToSavedBoxes(this);
        model.accept(this);
    }

    public EndimatorModelRenderer(int textureWidthIn, int textureHeightIn, int textureOffsetXIn, int textureOffsetYIn) {
        super(textureWidthIn, textureHeightIn, textureOffsetXIn, textureOffsetYIn);
        this.setScale(1.0f, 1.0f, 1.0f);
    }

    public void addChild(EndimatorModelRenderer renderer) {
        this.childModels.add((Object)renderer);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public EndimatorModelRenderer setTextureOffset(int x, int y) {
        this.field_78803_o = x;
        this.field_78813_p = y;
        return this;
    }

    public EndimatorModelRenderer setTextureSize(int textureWidthIn, int textureHeightIn) {
        this.field_78801_a = textureWidthIn;
        this.field_78799_b = textureHeightIn;
        return this;
    }

    public EndimatorModelRenderer addBox(String partName, float x, float y, float z, int width, int height, int depth, float delta, int texX, int texY) {
        this.setTextureOffset(texX, texY);
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, delta, delta, delta, this.field_78809_i, false);
        return this;
    }

    public EndimatorModelRenderer addBox(float x, float y, float z, float width, float height, float depth) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, this.field_78809_i, false);
        return this;
    }

    public EndimatorModelRenderer addBox(float x, float y, float z, float width, float height, float depth, boolean mirrorIn) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, mirrorIn, false);
        return this;
    }

    public void func_228301_a_(float x, float y, float z, float width, float height, float depth, float delta) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, delta, delta, delta, this.field_78809_i, false);
    }

    public void func_228302_a_(float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, this.field_78809_i, false);
    }

    public void func_228303_a_(float x, float y, float z, float width, float height, float depth, float delta, boolean mirrorIn) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, delta, delta, delta, mirrorIn, false);
    }

    private void addBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirorIn, boolean p_228305_13_) {
        this.cubeList.add((Object)new ModelBox(texOffX, texOffY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, mirorIn, this.field_78801_a, this.field_78799_b));
    }

    public void setDefaultBoxValues() {
        this.defaultRotationPointX = this.field_78800_c;
        this.defaultRotationPointY = this.field_78797_d;
        this.defaultRotationPointZ = this.field_78798_e;
        this.defaultOffsetX = this.offsetX;
        this.defaultOffsetY = this.offsetY;
        this.defaultOffsetZ = this.offsetZ;
        this.defaultRotateAngleX = this.field_78795_f;
        this.defaultRotateAngleY = this.field_78796_g;
        this.defaultRotateAngleZ = this.field_78808_h;
        this.defaultScaleX = this.scaleX;
        this.defaultScaleY = this.scaleY;
        this.defaultScaleZ = this.scaleZ;
    }

    public void revertToDefaultBoxValues() {
        this.field_78800_c = this.defaultRotationPointX;
        this.field_78797_d = this.defaultRotationPointY;
        this.field_78798_e = this.defaultRotationPointZ;
        this.offsetX = this.defaultOffsetX;
        this.offsetY = this.defaultOffsetY;
        this.offsetZ = this.defaultOffsetZ;
        this.field_78795_f = this.defaultRotateAngleX;
        this.field_78796_g = this.defaultRotateAngleY;
        this.field_78808_h = this.defaultRotateAngleZ;
        this.scaleX = this.defaultScaleX;
        this.scaleY = this.defaultScaleY;
        this.scaleZ = this.defaultScaleZ;
    }

    public void setScale(float x, float y, float z) {
        this.scaleX = x;
        this.scaleY = y;
        this.scaleZ = z;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public void setScaleZ(float scaleZ) {
        this.scaleZ = scaleZ;
    }

    public void applyScaling(EndimatorModelRenderer modelRenderer) {
        this.setScale(modelRenderer.field_78800_c, modelRenderer.field_78797_d, modelRenderer.field_78798_e);
    }

    public void setShouldScaleChildren(boolean scaleChildren) {
        this.scaleChildren = scaleChildren;
    }

    public void setDefaultOffset(float x, float y, float z) {
        this.defaultOffsetX = x;
        this.defaultOffsetY = y;
        this.defaultOffsetZ = z;
    }

    public void setOffset(float x, float y, float z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    public void func_228309_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (!(!this.field_78806_j || this.cubeList.isEmpty() && this.childModels.isEmpty())) {
            matrixStackIn.func_227860_a_();
            this.func_228307_a_(matrixStackIn);
            if (this.scaleChildren) {
                matrixStackIn.func_227861_a_((double)this.offsetX, (double)this.offsetY, (double)this.offsetZ);
                matrixStackIn.func_227862_a_(this.scaleX, this.scaleY, this.scaleZ);
                this.doRender(matrixStackIn.func_227866_c_(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                for (EndimatorModelRenderer modelrenderer : this.childModels) {
                    modelrenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                }
            } else {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_((double)this.offsetX, (double)this.offsetY, (double)this.offsetZ);
                matrixStackIn.func_227862_a_(this.scaleX, this.scaleY, this.scaleZ);
                this.doRender(matrixStackIn.func_227866_c_(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                matrixStackIn.func_227865_b_();
                for (EndimatorModelRenderer modelrenderer : this.childModels) {
                    modelrenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                }
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private void doRender(MatrixStack.Entry matrixEntryIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixEntryIn.func_227870_a_();
        Matrix3f matrix3f = matrixEntryIn.func_227872_b_();
        for (ModelBox modelrenderer$modelbox : this.cubeList) {
            for (TexturedQuad modelrenderer$texturedquad : modelrenderer$modelbox.quads) {
                Vector3f vector3f = modelrenderer$texturedquad.normal.func_229195_e_();
                vector3f.func_229188_a_(matrix3f);
                float f = vector3f.func_195899_a();
                float f1 = vector3f.func_195900_b();
                float f2 = vector3f.func_195902_c();
                for (int i = 0; i < 4; ++i) {
                    PositionTextureVertex modelrenderer$positiontexturevertex = modelrenderer$texturedquad.vertexPositions[i];
                    float f3 = modelrenderer$positiontexturevertex.position.func_195899_a() / 16.0f;
                    float f4 = modelrenderer$positiontexturevertex.position.func_195900_b() / 16.0f;
                    float f5 = modelrenderer$positiontexturevertex.position.func_195902_c() / 16.0f;
                    Vector4f vector4f = new Vector4f(f3, f4, f5, 1.0f);
                    vector4f.func_229372_a_(matrix4f);
                    bufferIn.func_225588_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c(), red, green, blue, alpha, modelrenderer$positiontexturevertex.textureU, modelrenderer$positiontexturevertex.textureV, packedOverlayIn, packedLightIn, f, f1, f2);
                }
            }
        }
    }

    protected static class TexturedQuad {
        public final PositionTextureVertex[] vertexPositions;
        public final Vector3f normal;

        public TexturedQuad(PositionTextureVertex[] positionsIn, float u1, float v1, float u2, float v2, float texWidth, float texHeight, boolean mirrorIn, Direction directionIn) {
            this.vertexPositions = positionsIn;
            float f = 0.0f / texWidth;
            float f1 = 0.0f / texHeight;
            positionsIn[0] = positionsIn[0].setTextureUV(u2 / texWidth - f, v1 / texHeight + f1);
            positionsIn[1] = positionsIn[1].setTextureUV(u1 / texWidth + f, v1 / texHeight + f1);
            positionsIn[2] = positionsIn[2].setTextureUV(u1 / texWidth + f, v2 / texHeight - f1);
            positionsIn[3] = positionsIn[3].setTextureUV(u2 / texWidth - f, v2 / texHeight - f1);
            if (mirrorIn) {
                int i = positionsIn.length;
                for (int j = 0; j < i / 2; ++j) {
                    PositionTextureVertex modelrenderer$positiontexturevertex = positionsIn[j];
                    positionsIn[j] = positionsIn[i - 1 - j];
                    positionsIn[i - 1 - j] = modelrenderer$positiontexturevertex;
                }
            }
            this.normal = directionIn.func_229386_k_();
            if (mirrorIn) {
                this.normal.func_229192_b_(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    protected static class PositionTextureVertex {
        public final Vector3f position;
        public final float textureU;
        public final float textureV;

        public PositionTextureVertex(float x, float y, float z, float texU, float texV) {
            this(new Vector3f(x, y, z), texU, texV);
        }

        public PositionTextureVertex setTextureUV(float texU, float texV) {
            return new PositionTextureVertex(this.position, texU, texV);
        }

        public PositionTextureVertex(Vector3f posIn, float texU, float texV) {
            this.position = posIn;
            this.textureU = texU;
            this.textureV = texV;
        }
    }

    public static class ModelBox {
        protected final TexturedQuad[] quads;
        public final float posX1;
        public final float posY1;
        public final float posZ1;
        public final float posX2;
        public final float posY2;
        public final float posZ2;

        public ModelBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirorIn, float texWidth, float texHeight) {
            this.posX1 = x;
            this.posY1 = y;
            this.posZ1 = z;
            this.posX2 = x + width;
            this.posY2 = y + height;
            this.posZ2 = z + depth;
            this.quads = new TexturedQuad[6];
            float f = x + width;
            float f1 = y + height;
            float f2 = z + depth;
            x -= deltaX;
            y -= deltaY;
            z -= deltaZ;
            f += deltaX;
            f1 += deltaY;
            f2 += deltaZ;
            if (mirorIn) {
                float f3 = f;
                f = x;
                x = f3;
            }
            PositionTextureVertex modelrenderer$positiontexturevertex7 = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex = new PositionTextureVertex(f, y, z, 0.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex1 = new PositionTextureVertex(f, f1, z, 8.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex2 = new PositionTextureVertex(x, f1, z, 8.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex3 = new PositionTextureVertex(x, y, f2, 0.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex4 = new PositionTextureVertex(f, y, f2, 0.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex5 = new PositionTextureVertex(f, f1, f2, 8.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex6 = new PositionTextureVertex(x, f1, f2, 8.0f, 0.0f);
            float f4 = texOffX;
            float f5 = (float)texOffX + depth;
            float f6 = (float)texOffX + depth + width;
            float f7 = (float)texOffX + depth + width + width;
            float f8 = (float)texOffX + depth + width + depth;
            float f9 = (float)texOffX + depth + width + depth + width;
            float f10 = texOffY;
            float f11 = (float)texOffY + depth;
            float f12 = (float)texOffY + depth + height;
            this.quads[2] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex}, f5, f10, f6, f11, texWidth, texHeight, mirorIn, Direction.DOWN);
            this.quads[3] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex1, modelrenderer$positiontexturevertex2, modelrenderer$positiontexturevertex6, modelrenderer$positiontexturevertex5}, f6, f11, f7, f10, texWidth, texHeight, mirorIn, Direction.UP);
            this.quads[1] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex6, modelrenderer$positiontexturevertex2}, f4, f11, f5, f12, texWidth, texHeight, mirorIn, Direction.WEST);
            this.quads[4] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex, modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex2, modelrenderer$positiontexturevertex1}, f5, f11, f6, f12, texWidth, texHeight, mirorIn, Direction.NORTH);
            this.quads[0] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex, modelrenderer$positiontexturevertex1, modelrenderer$positiontexturevertex5}, f6, f11, f8, f12, texWidth, texHeight, mirorIn, Direction.EAST);
            this.quads[5] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex5, modelrenderer$positiontexturevertex6}, f8, f11, f9, f12, texWidth, texHeight, mirorIn, Direction.SOUTH);
        }
    }
}

