/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.AdvancementModifier;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class DisplayInfoModifier
extends AdvancementModifier<Config> {
    private static final Field DISPLAY_INFO_FIELD = ObfuscationReflectionHelper.findField(Advancement.Builder.class, (String)"field_192063_c");
    private static final Field ICON_FIELD = ObfuscationReflectionHelper.findField(DisplayInfo.class, (String)"field_192301_b");
    private static final Field BACKGROUND_FIELD = ObfuscationReflectionHelper.findField(DisplayInfo.class, (String)"field_192302_c");
    private static final Field SHOW_TOAST_FIELD = ObfuscationReflectionHelper.findField(DisplayInfo.class, (String)"field_193226_f");

    public DisplayInfoModifier() {
        super((element, conditionArrayParser) -> {
            JsonObject object = element.getAsJsonObject();
            AdvancementModifier.Mode mode = AdvancementModifier.Mode.deserialize(object);
            Optional<ITextComponent> title = JSONUtils.func_151204_g((JsonObject)object, (String)"title") ? Optional.ofNullable(ITextComponent.Serializer.func_240641_a_((JsonElement)object.get("title"))) : Optional.empty();
            Optional<ITextComponent> description = JSONUtils.func_151204_g((JsonObject)object, (String)"description") ? Optional.ofNullable(ITextComponent.Serializer.func_240641_a_((JsonElement)object.get("description"))) : Optional.empty();
            Optional<ItemStack> icon = JSONUtils.func_151204_g((JsonObject)object, (String)"icon") ? Optional.of(DisplayInfoModifier.deserializeIcon(JSONUtils.func_152754_s((JsonObject)object, (String)"icon"))) : Optional.empty();
            Optional<ResourceLocation> background = JSONUtils.func_151204_g((JsonObject)object, (String)"background") ? Optional.of(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"background"))) : Optional.empty();
            Optional<FrameType> frameType = JSONUtils.func_151204_g((JsonObject)object, (String)"frame") ? Optional.of(FrameType.func_192308_a((String)JSONUtils.func_151200_h((JsonObject)object, (String)"frame"))) : Optional.empty();
            Optional<Boolean> showToast = JSONUtils.func_151204_g((JsonObject)object, (String)"show_toast") ? Optional.of(JSONUtils.func_151212_i((JsonObject)object, (String)"show_toast")) : Optional.empty();
            Optional<Boolean> announceToChat = JSONUtils.func_151204_g((JsonObject)object, (String)"announce_to_chat") ? Optional.of(JSONUtils.func_151212_i((JsonObject)object, (String)"announce_to_chat")) : Optional.empty();
            Optional<Boolean> hidden = JSONUtils.func_151204_g((JsonObject)object, (String)"hidden") ? Optional.of(JSONUtils.func_151212_i((JsonObject)object, (String)"hidden")) : Optional.empty();
            return new Config(mode, title, description, icon, background, frameType, showToast, announceToChat, hidden);
        });
    }

    private static ItemStack deserializeIcon(JsonObject object) {
        if (!object.has("item")) {
            throw new JsonSyntaxException("Unsupported icon type, currently only items are supported (add 'item' key)");
        }
        Item item = JSONUtils.func_188180_i((JsonObject)object, (String)"item");
        if (object.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        ItemStack stack = new ItemStack((IItemProvider)item);
        if (object.has("nbt")) {
            try {
                CompoundNBT nbt = JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)object.get("nbt"), (String)"nbt"));
                stack.func_77982_d(nbt);
            }
            catch (CommandSyntaxException syntax) {
                throw new JsonSyntaxException("Invalid nbt tag: " + syntax.getMessage());
            }
        }
        return stack;
    }

    @Override
    public void modify(Advancement.Builder builder, Config config) {
        if (config.mode == AdvancementModifier.Mode.MODIFY) {
            try {
                DisplayInfo displayInfo = (DisplayInfo)DISPLAY_INFO_FIELD.get(builder);
                ITextComponent title = config.title.orElse(displayInfo.func_192297_a());
                ITextComponent description = config.description.orElse(displayInfo.func_193222_b());
                ItemStack icon = config.icon.orElse((ItemStack)ICON_FIELD.get(displayInfo));
                ResourceLocation background = config.background.orElse((ResourceLocation)BACKGROUND_FIELD.get(displayInfo));
                FrameType frameType = config.frame.orElse(displayInfo.func_192291_d());
                boolean showToast = config.showToast.orElse(SHOW_TOAST_FIELD.getBoolean(displayInfo));
                boolean announceToChat = config.announceToChat.orElse(displayInfo.func_193220_i());
                boolean hidden = config.hidden.orElse(displayInfo.func_193224_j());
                builder.func_203903_a(new DisplayInfo(icon, title, description, background, frameType, showToast, announceToChat, hidden));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        } else {
            builder.func_203903_a(new DisplayInfo(config.icon.orElse(ItemStack.field_190927_a), config.title.orElse(StringTextComponent.field_240750_d_), config.description.orElse(StringTextComponent.field_240750_d_), (ResourceLocation)config.background.orElse(null), config.frame.orElse(FrameType.TASK), config.showToast.orElse(true).booleanValue(), config.announceToChat.orElse(true).booleanValue(), config.hidden.orElse(false).booleanValue()));
        }
    }

    static class Config {
        private final AdvancementModifier.Mode mode;
        private final Optional<ITextComponent> title;
        private final Optional<ITextComponent> description;
        private final Optional<ItemStack> icon;
        private final Optional<ResourceLocation> background;
        private final Optional<FrameType> frame;
        private final Optional<Boolean> showToast;
        private final Optional<Boolean> announceToChat;
        private final Optional<Boolean> hidden;

        Config(AdvancementModifier.Mode mode, Optional<ITextComponent> title, Optional<ITextComponent> description, Optional<ItemStack> icon, Optional<ResourceLocation> background, Optional<FrameType> frame, Optional<Boolean> showToast, Optional<Boolean> announceToChat, Optional<Boolean> hidden) {
            this.mode = mode;
            this.title = title;
            this.description = description;
            this.icon = icon;
            this.background = background;
            this.frame = frame;
            this.showToast = showToast;
            this.announceToChat = announceToChat;
            this.hidden = hidden;
        }
    }
}

