/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.client.tile;

import com.minecraftabnormals.abnormals_core.common.blocks.sign.AbnormalsAbstractSignBlock;
import com.minecraftabnormals.abnormals_core.common.blocks.sign.AbnormalsStandingSignBlock;
import com.minecraftabnormals.abnormals_core.common.blocks.sign.AbnormalsWallSignBlock;
import com.minecraftabnormals.abnormals_core.common.tileentity.AbnormalsSignTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbnormalsSignTileEntityRenderer<A extends AbnormalsSignTileEntity>
extends TileEntityRenderer<A> {
    private final SignModel model = new SignModel();

    public AbnormalsSignTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(A sign, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate = sign.func_195044_w();
        matrixStack.func_227860_a_();
        if (blockstate.func_177230_c() instanceof AbnormalsStandingSignBlock) {
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            float f1 = -((float)((Integer)blockstate.func_177229_b((Property)AbnormalsStandingSignBlock.ROTATION) * 360) / 16.0f);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
            this.model.signStick.field_78806_j = true;
        } else {
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            float f4 = -((Direction)blockstate.func_177229_b((Property)AbnormalsWallSignBlock.FACING)).func_185119_l();
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f4));
            matrixStack.func_227861_a_(0.0, -0.3125, -0.4375);
            this.model.signStick.field_78806_j = false;
        }
        float scale = 0.6666667f;
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale, -scale, -scale);
        IVertexBuilder ivertexbuilder = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)AbnormalsSignTileEntityRenderer.getTexture(blockstate)));
        this.model.signBoard.func_228308_a_(matrixStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        this.model.signStick.func_228308_a_(matrixStack, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        matrixStack.func_227865_b_();
        FontRenderer fontrenderer = this.field_228858_b_.func_147548_a();
        float textScale = 0.010416667f;
        matrixStack.func_227861_a_(0.0, 0.3333333432674408, 0.046666666865348816);
        matrixStack.func_227862_a_(textScale, -textScale, textScale);
        int i = ((AbnormalsSignTileEntity)((Object)sign)).getTextColor().func_218388_g();
        double colorMultiplier = 0.4;
        int j = (int)((double)NativeImage.func_227791_b_((int)i) * colorMultiplier);
        int k = (int)((double)NativeImage.func_227793_c_((int)i) * colorMultiplier);
        int l = (int)((double)NativeImage.func_227795_d_((int)i) * colorMultiplier);
        int i1 = NativeImage.func_227787_a_((int)0, (int)l, (int)k, (int)j);
        for (int line = 0; line < 4; ++line) {
            IReorderingProcessor processor = ((AbnormalsSignTileEntity)((Object)sign)).getRenderText(line, p_239309_1_ -> {
                List list = fontrenderer.func_238425_b_((ITextProperties)p_239309_1_, 90);
                return list.isEmpty() ? IReorderingProcessor.field_242232_a : (IReorderingProcessor)list.get(0);
            });
            if (processor == null) continue;
            float f3 = -fontrenderer.func_243245_a(processor) / 2;
            fontrenderer.func_238416_a_(processor, f3, (float)(line * 10 - 20), i1, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLightIn);
        }
        matrixStack.func_227865_b_();
    }

    public static ResourceLocation getTexture(BlockState state) {
        return ((AbnormalsAbstractSignBlock)state.func_177230_c()).getTextureLocation();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class SignModel
    extends Model {
        public final ModelRenderer signBoard = new ModelRenderer(64, 32, 0, 0);
        public final ModelRenderer signStick;

        public SignModel() {
            super(RenderType::func_228640_c_);
            this.signBoard.func_228301_a_(-12.0f, -14.0f, -1.0f, 24.0f, 12.0f, 2.0f, 0.0f);
            this.signStick = new ModelRenderer(64, 32, 0, 14);
            this.signStick.func_228301_a_(-1.0f, -2.0f, -1.0f, 2.0f, 14.0f, 2.0f, 0.0f);
        }

        public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.signBoard.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.signStick.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }
}

