/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.common.entity.passive;

import com.minecraftabnormals.autumnity.core.other.AutumnityTags;
import com.minecraftabnormals.autumnity.core.registry.AutumnityEntities;
import com.minecraftabnormals.autumnity.core.registry.AutumnityItems;
import com.minecraftabnormals.autumnity.core.registry.AutumnitySoundEvents;
import com.minecraftabnormals.environmental.api.IEggLayingEntity;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TurkeyEntity
extends AnimalEntity
implements IEggLayingEntity,
IAngerable {
    private static final DataParameter<Integer> ANGER_TIME = EntityDataManager.func_187226_a(TurkeyEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private float wingRotation;
    private float destPos;
    private float oFlapSpeed;
    private float oFlap;
    private float wingRotDelta = 1.0f;
    private float peckTicks;
    private float prevPeckTicks;
    public int timeUntilNextEgg = this.field_70146_Z.nextInt(9600) + 9600;
    public boolean turkeyJockey;
    private static final RangedInteger ANGER_RANGE = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private UUID lastHurtBy;

    public TurkeyEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.3f));
        this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.4, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, Ingredient.func_199805_a(AutumnityTags.TURKEY_BREEDING_ITEMS)));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((TurkeyEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(3, new JockeyTargetGoal<PlayerEntity>(this, PlayerEntity.class));
        this.field_70715_bh.func_75776_a(4, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.85f : sizeIn.field_220316_b * 0.92f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGER_TIME, (Object)0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.peckTicks = 8.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        this.peckTicks = 8.0f;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        return super.func_70652_k(entityIn);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.oFlap = this.wingRotation;
            this.oFlapSpeed = this.destPos;
            this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
            this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
            if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
                this.wingRotDelta = 1.0f;
            }
            this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
            this.wingRotation += this.wingRotDelta * 2.0f;
        }
        this.prevPeckTicks = this.peckTicks;
        if (this.peckTicks > 0.0f) {
            this.peckTicks -= 1.0f;
        }
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.6, 1.0));
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70089_S() && !this.func_70631_g_() && !this.isTurkeyJockey() && --this.timeUntilNextEgg <= 0) {
                this.func_184185_a((SoundEvent)AutumnitySoundEvents.ENTITY_TURKEY_EGG.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_199703_a((IItemProvider)AutumnityItems.TURKEY_EGG.get());
                this.timeUntilNextEgg = this.getNextEggTime(this.field_70146_Z);
            }
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getWingRotation(float partialTicks) {
        float f = MathHelper.func_219799_g((float)partialTicks, (float)this.oFlap, (float)this.wingRotation);
        float f1 = MathHelper.func_219799_g((float)partialTicks, (float)this.oFlapSpeed, (float)this.destPos);
        return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getPeckProgress(float partialTicks) {
        float f = MathHelper.func_219799_g((float)partialTicks, (float)this.prevPeckTicks, (float)this.peckTicks) / 8.0f;
        if (f < 0.5f) {
            return 2.0f * f;
        }
        return -2.0f * f + 2.0f;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.func_233678_J__() ? (SoundEvent)AutumnitySoundEvents.ENTITY_TURKEY_AGGRO.get() : (SoundEvent)AutumnitySoundEvents.ENTITY_TURKEY_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)AutumnitySoundEvents.ENTITY_TURKEY_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AutumnitySoundEvents.ENTITY_TURKEY_DEATH.get();
    }

    @Override
    public SoundEvent getEggLayingSound() {
        return (SoundEvent)AutumnitySoundEvents.ENTITY_TURKEY_EGG.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return Ingredient.func_199805_a(AutumnityTags.TURKEY_BREEDING_ITEMS).test(stack);
    }

    protected int func_70693_a(PlayerEntity player) {
        return this.isTurkeyJockey() ? 10 : super.func_70693_a(player);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.turkeyJockey = compound.func_74767_n("IsTurkeyJockey");
        if (compound.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = compound.func_74762_e("EggLayTime");
        }
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsTurkeyJockey", this.turkeyJockey);
        compound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
        this.func_233682_c_(compound);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.isTurkeyJockey();
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        passenger.func_70107_b(this.func_226277_ct_() + (double)(0.1f * f), this.func_226283_e_(0.5) + passenger.func_70033_W() + 0.0, this.func_226281_cx_() - (double)(0.1f * f1));
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    public boolean isTurkeyJockey() {
        return this.turkeyJockey;
    }

    public void setTurkeyJockey(boolean jockey) {
        this.turkeyJockey = jockey;
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER_TIME);
    }

    public void func_230260_a__(int time) {
        this.field_70180_af.func_187227_b(ANGER_TIME, (Object)time);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return (AgeableEntity)((EntityType)AutumnityEntities.TURKEY.get()).func_200721_a((World)world);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)AutumnityItems.TURKEY_SPAWN_EGG.get());
    }

    public UUID func_230257_G__() {
        return this.lastHurtBy;
    }

    public void func_230259_a_(UUID target) {
        this.lastHurtBy = target;
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_RANGE.func_233018_a_(this.field_70146_Z));
    }

    @Override
    public int getEggTimer() {
        return this.timeUntilNextEgg;
    }

    @Override
    public void setEggTimer(int time) {
        this.timeUntilNextEgg = time;
    }

    @Override
    public boolean isBirdJockey() {
        return this.turkeyJockey;
    }

    @Override
    public Item getEggItem() {
        return (Item)AutumnityItems.TURKEY_EGG.get();
    }

    @Override
    public int getNextEggTime(Random rand) {
        return rand.nextInt(9600) + 9600;
    }

    static class JockeyTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public JockeyTargetGoal(TurkeyEntity turkey, Class<T> classTarget) {
            super((MobEntity)turkey, classTarget, true);
        }

        public boolean func_75250_a() {
            TurkeyEntity turkey = (TurkeyEntity)this.field_75299_d;
            return turkey.isTurkeyJockey() && super.func_75250_a();
        }
    }

    static class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal(TurkeyEntity turkey) {
            super((CreatureEntity)turkey, new Class[0]);
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof TurkeyEntity && !mobIn.func_70631_g_()) {
                super.func_220793_a(mobIn, targetIn);
            }
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (this.field_75299_d.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }
    }

    static class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal(TurkeyEntity turkey) {
            super((CreatureEntity)turkey, 1.4);
        }

        public boolean func_75250_a() {
            return this.field_75267_a.func_70631_g_() && super.func_75250_a();
        }
    }
}

