/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.mc;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class ColorUtils {
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int YELLOW = -256;
    public static final int CYAN = 0xFF0001;
    public static final int MAGENTA = -65281;
    public static final int BLACK = -16777216;

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int toInt(int red, int green, int blue, int alpha) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int toInt(Vector3i color) {
        return 0xFF000000 | (color.func_177958_n() & 0xFF) << 16 | (color.func_177956_o() & 0xFF) << 8 | color.func_177952_p() & 0xFF;
    }

    public static Vector3i toIntVec(int color) {
        float r = color >> 16 & 0xFF;
        float g = color >> 8 & 0xFF;
        float b = color & 0xFF;
        return new Vector3i((double)r, (double)g, (double)b);
    }

    public static Vector3d toVec(int color) {
        float r = color >> 16 & 0xFF;
        float g = color >> 8 & 0xFF;
        float b = color & 0xFF;
        return new Vector3d((double)(r / 255.0f), (double)(g / 255.0f), (double)(b / 255.0f));
    }

    public static boolean isWhite(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return r == 255 && g == 255 && b == 255;
    }

    public static boolean isTransparent(int color) {
        int a = color >> 24 & 0xFF;
        return a < 255;
    }

    public static boolean isInvisible(int color) {
        int a = color >> 24 & 0xFF;
        return a == 0;
    }

    public static int blend(int i1, int i2) {
        return ColorUtils.blend(i1, i2, 0.5f);
    }

    public static int blend(int i1, int i2, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int a1 = i1 >> 24 & 0xFF;
        int r1 = (i1 & 0xFF0000) >> 16;
        int g1 = (i1 & 0xFF00) >> 8;
        int b1 = i1 & 0xFF;
        int a2 = i2 >> 24 & 0xFF;
        int r2 = (i2 & 0xFF0000) >> 16;
        int g2 = (i2 & 0xFF00) >> 8;
        int b2 = i2 & 0xFF;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static enum ColorPart {
        RED(-16777216),
        GREEN(0xFF0000),
        BLUE(65280),
        ALPHA(255);

        public final int code;

        private ColorPart(int code) {
            this.code = code;
        }
    }

    public static class Color {
        public int red;
        public int green;
        public int blue;
        public int alpha;

        public Color(int color) {
            this.red = ColorUtils.getRed(color);
            this.green = ColorUtils.getGreen(color);
            this.blue = ColorUtils.getBlue(color);
            this.alpha = ColorUtils.getAlpha(color);
        }

        public Color(Vector3i vec) {
            this.red = vec.func_177958_n();
            this.green = vec.func_177956_o();
            this.blue = vec.func_177952_p();
            this.alpha = 255;
        }

        public Color(Vector3d vec) {
            this.red = (int)(vec.func_82615_a() * 255.0);
            this.green = (int)(vec.func_82617_b() * 255.0);
            this.blue = (int)(vec.func_82616_c() * 255.0);
            this.alpha = 255;
        }

        public Color(int red, int green, int blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = 255;
        }

        public Color(int red, int green, int blue, int alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public void glColor() {
            RenderSystem.color4f((float)((float)this.red / 255.0f), (float)((float)this.green / 255.0f), (float)((float)this.blue / 255.0f), (float)((float)this.alpha / 255.0f));
        }

        public Vector3d toVec(ColorPart part) {
            return new Vector3d((double)this.red / 255.0, (double)this.green / 255.0, (double)this.blue / 255.0);
        }

        public float getDecimal(ColorPart part) {
            return (float)this.get(part) / 255.0f;
        }

        public int get(ColorPart part) {
            switch (part) {
                case RED: {
                    return this.red;
                }
                case GREEN: {
                    return this.green;
                }
                case BLUE: {
                    return this.blue;
                }
                case ALPHA: {
                    return this.alpha;
                }
            }
            return 0;
        }

        public void set(ColorPart part, int value) {
            switch (part) {
                case RED: {
                    this.red = value;
                    break;
                }
                case GREEN: {
                    this.green = value;
                    break;
                }
                case BLUE: {
                    this.blue = value;
                    break;
                }
                case ALPHA: {
                    this.alpha = value;
                }
            }
        }

        public int toInt() {
            return (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
        }

        public boolean isWhite(int color) {
            return this.red == 255 && this.green == 255 && this.blue == 255;
        }

        public boolean isTransparent() {
            return this.alpha < 255;
        }

        public boolean isInvisible() {
            return this.alpha == 0;
        }

        public int blend(Color color) {
            return this.blend(color, 0.5f);
        }

        public int blend(Color color, float ratio) {
            if (ratio > 1.0f) {
                ratio = 1.0f;
            } else if (ratio < 0.0f) {
                ratio = 0.0f;
            }
            float iRatio = 1.0f - ratio;
            int a = (int)((float)color.alpha * iRatio + (float)this.alpha * ratio);
            int r = (int)((float)color.red * iRatio + (float)this.red * ratio);
            int g = (int)((float)color.green * iRatio + (float)this.green * ratio);
            int b = (int)((float)color.blue * iRatio + (float)this.blue * ratio);
            return a << 24 | r << 16 | g << 8 | b;
        }
    }
}

