/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import team.creative.creativecore.common.network.CanBeNull;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeFieldParserEntry {
    private static final Gson GSON = new Gson();
    public final Field field;
    public boolean nullable;
    public final CreativeFieldParser parser;
    private static final List<CreativeFieldParserSpecial> specialParsers = new ArrayList<CreativeFieldParserSpecial>();
    private static final HashMap<Class<?>, CreativeFieldParser> parsers = new HashMap();

    public CreativeFieldParserEntry(Field field, CreativeFieldParser parser) {
        this.field = field;
        this.nullable = field.isAnnotationPresent(CanBeNull.class);
        this.parser = parser;
    }

    public void write(CreativePacket packet, PacketBuffer buffer) {
        try {
            Object content = this.field.get(packet);
            if (this.nullable) {
                buffer.writeBoolean(content != null);
            }
            if (content != null) {
                this.parser.write(content, this.field.getType(), this.field.getGenericType(), buffer);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void read(CreativePacket packet, PacketBuffer buffer) {
        try {
            Object content = this.nullable && !buffer.readBoolean() ? null : this.parser.read(this.field.getType(), this.field.getGenericType(), buffer);
            this.field.set(packet, content);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static <T> void registerParser(Class<T> classType, CreativeFieldParser parser) {
        parsers.put(classType, parser);
    }

    public static <T> void registerSpecialParser(CreativeFieldParserSpecial parser) {
        specialParsers.add(parser);
    }

    public static CreativeFieldParserEntry getParser(Field field) {
        CreativeFieldParser parser = CreativeFieldParserEntry.getParser(field.getType(), field.getGenericType());
        if (parser != null) {
            return new CreativeFieldParserEntry(field, parser);
        }
        return null;
    }

    public static CreativeFieldParser getParser(Class classType, Type genericType) {
        try {
            CreativeFieldParser parser = parsers.get(classType);
            if (parser != null) {
                return parser;
            }
            for (int i = 0; i < specialParsers.size(); ++i) {
                if (!CreativeFieldParserEntry.specialParsers.get((int)i).predicate.test(classType, genericType)) continue;
                return specialParsers.get(i);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return null;
    }

    static {
        SimpleFieldParser<Boolean> booleanParser = new SimpleFieldParser<Boolean>(){

            @Override
            protected void writeContent(Boolean content, PacketBuffer buffer) {
                buffer.writeBoolean(content.booleanValue());
            }

            @Override
            protected Boolean readContent(PacketBuffer buffer) {
                return buffer.readBoolean();
            }
        };
        CreativeFieldParserEntry.registerParser(Boolean.TYPE, booleanParser);
        CreativeFieldParserEntry.registerParser(Boolean.class, booleanParser);
        SimpleFieldParser<Byte> byteParser = new SimpleFieldParser<Byte>(){

            @Override
            protected void writeContent(Byte content, PacketBuffer buffer) {
                buffer.writeByte((int)content.byteValue());
            }

            @Override
            protected Byte readContent(PacketBuffer buffer) {
                return buffer.readByte();
            }
        };
        CreativeFieldParserEntry.registerParser(Byte.TYPE, byteParser);
        CreativeFieldParserEntry.registerParser(Byte.class, byteParser);
        SimpleFieldParser<Short> shortParser = new SimpleFieldParser<Short>(){

            @Override
            protected void writeContent(Short content, PacketBuffer buffer) {
                buffer.writeShort((int)content.shortValue());
            }

            @Override
            protected Short readContent(PacketBuffer buffer) {
                return buffer.readShort();
            }
        };
        CreativeFieldParserEntry.registerParser(Short.TYPE, shortParser);
        CreativeFieldParserEntry.registerParser(Short.class, shortParser);
        SimpleFieldParser<Integer> intParser = new SimpleFieldParser<Integer>(){

            @Override
            protected void writeContent(Integer content, PacketBuffer buffer) {
                buffer.writeInt(content.intValue());
            }

            @Override
            protected Integer readContent(PacketBuffer buffer) {
                return buffer.readInt();
            }
        };
        CreativeFieldParserEntry.registerParser(Integer.TYPE, intParser);
        CreativeFieldParserEntry.registerParser(Integer.class, intParser);
        SimpleFieldParser<Long> longParser = new SimpleFieldParser<Long>(){

            @Override
            protected void writeContent(Long content, PacketBuffer buffer) {
                buffer.writeLong(content.longValue());
            }

            @Override
            protected Long readContent(PacketBuffer buffer) {
                return buffer.readLong();
            }
        };
        CreativeFieldParserEntry.registerParser(Long.TYPE, longParser);
        CreativeFieldParserEntry.registerParser(Long.class, longParser);
        SimpleFieldParser<Float> floatParser = new SimpleFieldParser<Float>(){

            @Override
            protected void writeContent(Float content, PacketBuffer buffer) {
                buffer.writeFloat(content.floatValue());
            }

            @Override
            protected Float readContent(PacketBuffer buffer) {
                return Float.valueOf(buffer.readFloat());
            }
        };
        CreativeFieldParserEntry.registerParser(Float.TYPE, floatParser);
        CreativeFieldParserEntry.registerParser(Float.class, floatParser);
        SimpleFieldParser<Double> doubleParser = new SimpleFieldParser<Double>(){

            @Override
            protected void writeContent(Double content, PacketBuffer buffer) {
                buffer.writeDouble(content.doubleValue());
            }

            @Override
            protected Double readContent(PacketBuffer buffer) {
                return buffer.readDouble();
            }
        };
        CreativeFieldParserEntry.registerParser(Double.TYPE, doubleParser);
        CreativeFieldParserEntry.registerParser(Double.class, doubleParser);
        CreativeFieldParserEntry.registerParser(BlockPos.class, new SimpleFieldParser<BlockPos>(){

            @Override
            protected void writeContent(BlockPos content, PacketBuffer buffer) {
                buffer.func_179255_a(content);
            }

            @Override
            protected BlockPos readContent(PacketBuffer buffer) {
                return buffer.func_179259_c();
            }
        });
        CreativeFieldParserEntry.registerParser(String.class, new SimpleFieldParser<String>(){

            @Override
            protected void writeContent(String content, PacketBuffer buffer) {
                buffer.func_180714_a(content);
            }

            @Override
            protected String readContent(PacketBuffer buffer) {
                return buffer.func_150789_c(Short.MAX_VALUE);
            }
        });
        CreativeFieldParserEntry.registerParser(ITextComponent.class, new SimpleFieldParser<ITextComponent>(){

            @Override
            protected void writeContent(ITextComponent content, PacketBuffer buffer) {
                buffer.func_179256_a(content);
            }

            @Override
            protected ITextComponent readContent(PacketBuffer buffer) {
                return buffer.func_179258_d();
            }
        });
        CreativeFieldParserEntry.registerParser(CompoundNBT.class, new SimpleFieldParser<CompoundNBT>(){

            @Override
            protected void writeContent(CompoundNBT content, PacketBuffer buffer) {
                buffer.func_150786_a(content);
            }

            @Override
            protected CompoundNBT readContent(PacketBuffer buffer) {
                return buffer.func_150793_b();
            }
        });
        CreativeFieldParserEntry.registerParser(ItemStack.class, new SimpleFieldParser<ItemStack>(){

            @Override
            protected void writeContent(ItemStack content, PacketBuffer buffer) {
                buffer.func_150788_a(content);
            }

            @Override
            protected ItemStack readContent(PacketBuffer buffer) {
                return buffer.func_150791_c();
            }
        });
        CreativeFieldParserEntry.registerParser(ResourceLocation.class, new SimpleFieldParser<ResourceLocation>(){

            @Override
            protected void writeContent(ResourceLocation content, PacketBuffer buffer) {
                buffer.func_192572_a(content);
            }

            @Override
            protected ResourceLocation readContent(PacketBuffer buffer) {
                return buffer.func_192575_l();
            }
        });
        CreativeFieldParserEntry.registerParser(BlockState.class, new SimpleFieldParser<BlockState>(){

            @Override
            protected void writeContent(BlockState content, PacketBuffer buffer) {
                buffer.writeInt(Block.func_196246_j((BlockState)content));
            }

            @Override
            protected BlockState readContent(PacketBuffer buffer) {
                return Block.func_196257_b((int)buffer.readInt());
            }
        });
        CreativeFieldParserEntry.registerParser(Vector3d.class, new SimpleFieldParser<Vector3d>(){

            @Override
            protected void writeContent(Vector3d content, PacketBuffer buffer) {
                buffer.writeDouble(content.field_72450_a);
                buffer.writeDouble(content.field_72448_b);
                buffer.writeDouble(content.field_72449_c);
            }

            @Override
            protected Vector3d readContent(PacketBuffer buffer) {
                return new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        });
        CreativeFieldParserEntry.registerParser(UUID.class, new SimpleFieldParser<UUID>(){

            @Override
            protected void writeContent(UUID content, PacketBuffer buffer) {
                buffer.func_180714_a(content.toString());
            }

            @Override
            protected UUID readContent(PacketBuffer buffer) {
                return UUID.fromString(buffer.func_150789_c(Short.MAX_VALUE));
            }
        });
        CreativeFieldParserEntry.registerParser(JsonObject.class, new SimpleFieldParser<JsonObject>(){

            @Override
            protected void writeContent(JsonObject content, PacketBuffer buffer) {
                buffer.func_180714_a(content.toString());
            }

            @Override
            protected JsonObject readContent(PacketBuffer buffer) {
                return (JsonObject)GSON.fromJson(buffer.func_150789_c(Short.MAX_VALUE), JsonObject.class);
            }
        });
        CreativeFieldParserEntry.registerSpecialParser(new CreativeFieldParserSpecial((x, y) -> x.isArray()){

            @Override
            public void write(Object content, Class classType, Type genericType, PacketBuffer buffer) {
                Class<?> subClass = classType.getComponentType();
                CreativeFieldParser subParser = CreativeFieldParserEntry.getParser(subClass, null);
                int length = Array.getLength(content);
                buffer.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    subParser.write(Array.get(content, i), subClass, null, buffer);
                }
            }

            @Override
            public Object read(Class classType, Type genericType, PacketBuffer buffer) {
                int length = buffer.readInt();
                Class<?> subClass = classType.getComponentType();
                CreativeFieldParser subParser = CreativeFieldParserEntry.getParser(subClass, null);
                Object object = Array.newInstance(subClass, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(object, i, subParser.read(subClass, null, buffer));
                }
                return object;
            }
        });
        CreativeFieldParserEntry.registerSpecialParser(new CreativeFieldParserSpecial((x, y) -> x.equals(ArrayList.class) || x.equals(List.class)){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void write(Object content, Class classType, Type genericType, PacketBuffer buffer) {
                Type subType;
                if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Missing generic type");
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                if (types.length != 1) throw new RuntimeException("Invalid generic type");
                Class subClass = (Class)((ParameterizedType)genericType).getRawType();
                CreativeFieldParser subParser = CreativeFieldParserEntry.getParser(subClass, subType = types[0]);
                if (subParser == null) {
                    throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                }
                int length = ((List)content).size();
                buffer.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    subParser.write(((List)content).get(i), subClass, subType, buffer);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object read(Class classType, Type genericType, PacketBuffer buffer) {
                Type subType;
                if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Missing generic type");
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                if (types.length != 1) throw new RuntimeException("Invalid generic type");
                Class subClass = (Class)((ParameterizedType)genericType).getRawType();
                CreativeFieldParser subParser = CreativeFieldParserEntry.getParser(subClass, subType = types[0]);
                if (subParser == null) {
                    throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                }
                int length = buffer.readInt();
                ArrayList list = new ArrayList(length);
                for (int j = 0; j < length; ++j) {
                    list.add(subParser.read(subClass, subType, buffer));
                }
                return list;
            }
        });
        CreativeFieldParserEntry.registerSpecialParser(new CreativeFieldParserSpecial((x, y) -> x.isEnum()){

            @Override
            public void write(Object content, Class classType, Type genericType, PacketBuffer buffer) {
                buffer.func_179249_a((Enum)content);
            }

            @Override
            public Object read(Class classType, Type genericType, PacketBuffer buffer) {
                return buffer.func_179257_a(classType);
            }
        });
    }

    @FunctionalInterface
    public static interface BiPredicate<T, V> {
        public boolean test(T var1, V var2);
    }

    public static abstract class CreativeFieldParserSpecial
    extends CreativeFieldParser<Object> {
        public final BiPredicate<Class, Type> predicate;

        public CreativeFieldParserSpecial(BiPredicate<Class, Type> predicate) {
            this.predicate = predicate;
        }
    }

    public static abstract class SimpleFieldParser<T>
    extends CreativeFieldParser<T> {
        protected abstract void writeContent(T var1, PacketBuffer var2);

        @Override
        public void write(T content, Class classType, Type genericType, PacketBuffer buffer) {
            this.writeContent(content, buffer);
        }

        protected abstract T readContent(PacketBuffer var1);

        @Override
        public T read(Class classType, Type genericType, PacketBuffer buffer) {
            return this.readContent(buffer);
        }
    }

    public static abstract class CreativeFieldParser<T> {
        public abstract void write(T var1, Class var2, Type var3, PacketBuffer var4);

        public abstract T read(Class var1, Type var2, PacketBuffer var3);
    }
}

