/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.IGuiParent;

public abstract class GuiParent
extends GuiControl
implements IGuiParent,
Iterable<GuiControl> {
    protected List<GuiControl> controls = new ArrayList<GuiControl>();

    public GuiParent(String name, int x, int y, int width, int height) {
        super(name, x, y, width, height);
    }

    public abstract void tick();

    @Override
    public Iterator<GuiControl> iterator() {
        return this.controls.iterator();
    }

    public GuiControl get(String name) {
        for (int i = 0; i < this.controls.size(); ++i) {
            if (!this.controls.get((int)i).name.equalsIgnoreCase(name)) continue;
            return this.controls.get(i);
        }
        return null;
    }

    public boolean has(String name) {
        for (int i = 0; i < this.controls.size(); ++i) {
            if (!this.controls.get((int)i).name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void add(GuiControl control) {
        control.setParent(this);
        this.controls.add(control);
    }

    public void remove(String ... include) {
        this.controls.removeIf(x -> ArrayUtils.contains((Object[])include, (Object)x.name));
    }

    public void removeExclude(String ... exclude) {
        this.controls.removeIf(x -> !ArrayUtils.contains((Object[])exclude, (Object)x.name));
    }

    public void clear() {
        this.controls.clear();
    }

    @Override
    public void moveBehind(GuiControl toMove, GuiControl reference) {
        this.controls.remove(toMove);
        int index = this.controls.indexOf(reference);
        if (index != -1 && index < this.controls.size() - 1) {
            this.controls.add(index + 1, toMove);
        } else {
            this.moveBottom(toMove);
        }
    }

    @Override
    public void moveInFront(GuiControl toMove, GuiControl reference) {
        this.controls.remove(toMove);
        int index = this.controls.indexOf(reference);
        if (index != -1) {
            this.controls.add(index, toMove);
        } else {
            this.moveTop(toMove);
        }
    }

    @Override
    public void moveTop(GuiControl toMove) {
        this.controls.remove(toMove);
        this.controls.add(0, toMove);
    }

    @Override
    public void moveBottom(GuiControl toMove) {
        this.controls.remove(toMove);
        this.controls.add(toMove);
    }
}

